<?php
// voicechat/api/store/apply.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

$pdo = db();
$me  = require_user();

$item_id  = (int)($_POST['item_id'] ?? $_GET['item_id'] ?? 0);
$category = trim($_POST['category'] ?? $_GET['category'] ?? 'frame');
if ($item_id<=0) json_out(['ok'=>0,'error'=>'item_id_required']);

$now = time();

/* تحقّق الملكية والصلاحية */
$sel = $pdo->prepare("SELECT usi.id, usi.expires_at
  FROM user_store_items usi
  JOIN store_items si ON si.id=usi.item_id
  WHERE usi.user_id=? AND usi.item_id=? AND si.is_active=1 AND si.category=?");
$sel->execute([$me, $item_id, $category]);
$row = $sel->fetch(PDO::FETCH_ASSOC);
if (!$row) json_out(['ok'=>0,'error'=>'not_owned']);
if ($row['expires_at'] && strtotime($row['expires_at']) <= $now)
  json_out(['ok'=>0,'error'=>'expired']);

/* تطبيق حسب الفئة */
switch ($category) {
  case 'frame':
    $pdo->prepare("UPDATE users SET current_frame_item_id=? WHERE id=?")
        ->execute([$item_id, $me]);
    break;

  case 'room_plate':
  case 'color_theme':
    // مكان مبدئي لتطبيق أنواع أخرى لاحقًا (احفظ اختيار المستخدم في users.* أو جدول تفضيلات)
    // مثال: users.current_theme_item_id / users.current_plate_item_id
    json_out(['ok'=>0, 'error'=>'apply_not_implemented_for_category']);
    break;

  default:
    json_out(['ok'=>0, 'error'=>'unknown_category']);
}

echo json_encode(['ok'=>1], JSON_UNESCAPED_UNICODE);
