<?php
// api/rooms_by_owner.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../db.php';

$owner_uid = isset($_GET['owner_uid']) ? trim($_GET['owner_uid']) : '';
if ($owner_uid === '') { http_response_code(400); echo json_encode(['error'=>'owner_uid required']); exit; }

$sql = "SELECT uid, owner_uid, name, description, image_url, status, created_at 
        FROM rooms WHERE owner_uid = :u ORDER BY id DESC LIMIT 200";
$stmt = $pdo->prepare($sql);
$stmt->execute([':u' => $owner_uid]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['items' => $rows], JSON_UNESCAPED_UNICODE);
