<?php
require __DIR__.'/../config.php';
header('Content-Type: application/json; charset=utf-8');

$uid = require_user();
$room_uid = trim($_GET['room_uid'] ?? '');

$pdo = db();
$st = $pdo->prepare("
  SELECT r.uid, r.owner_uid, r.name, r.status,
         (r.owner_uid = :me) AS is_owner
  FROM rooms r WHERE r.uid = :rid LIMIT 1
");
$st->execute([':me'=>$uid, ':rid'=>$room_uid]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if (!$row) { echo json_encode(['ok'=>false,'error'=>'not_found']); exit; }

echo json_encode([
  'ok' => true,
  'room' => [
    'uid' => $row['uid'],
    'owner_uid' => $row['owner_uid'],
    'name' => $row['name'],
    'status' => $row['status'],
  ],
  'is_owner' => ($row['is_owner'] == 1),
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
