<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

/* ===== 0) config ===== */
$CONFIG_PATHS = [
  __DIR__ . '/config.php',
  dirname(__DIR__) . '/config.php',
  __DIR__ . '/../config/config.php',
];
foreach ($CONFIG_PATHS as $p) { if (is_file($p)) { require_once $p; break; } }

function jerr($http,$msg,$extra=[]){
  http_response_code($http);
  echo json_encode(['ok'=>false,'online'=>0,'error'=>$msg]+$extra, JSON_UNESCAPED_UNICODE);
  exit;
}

/* ===== DB helpers ===== */
function resolve_pdo(){
  foreach (['pdo','db','conn','connection'] as $g) if (isset($GLOBALS[$g]) && $GLOBALS[$g] instanceof PDO) return $GLOBALS[$g];
  foreach (['db','get_pdo','pdo'] as $fn) if (function_exists($fn)){ $x=$fn(); if($x instanceof PDO) return $x; }
  if (defined('DB_DSN')) return new PDO(DB_DSN, defined('DB_USER')?DB_USER:null, defined('DB_PASS')?DB_PASS:null, [
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
  ]);
  if (defined('DB_HOST') && defined('DB_NAME')) {
    $charset = defined('DB_CHARSET') ? DB_CHARSET : 'utf8mb4';
    $dsn = "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset={$charset}";
    return new PDO($dsn, defined('DB_USER')?DB_USER:'', defined('DB_PASS')?DB_PASS:'', [
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
    ]);
  }
  $url=getenv('DATABASE_URL'); if($url){
    $p=parse_url($url); $scheme=$p['scheme']??'mysql';
    $host=$p['host']??'127.0.0.1'; $port=$p['port']??null; $user=$p['user']??''; $pass=$p['pass']??''; $db=ltrim($p['path']??'','/');
    $dsn = ($scheme==='postgres'||$scheme==='postgresql')
      ? "pgsql:host={$host};".($port?"port={$port};":"")."dbname={$db}"
      : "mysql:host={$host};".($port?"port={$port};":"")."dbname={$db};charset=utf8mb4";
    return new PDO($dsn,$user,$pass,[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC]);
  }
  return null;
}
function table_exists(PDO $pdo, string $name): bool {
  try { $st=$pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]); return (bool)$st->fetchColumn(); }
  catch(Throwable $e){ return false; }
}
function list_columns(PDO $pdo, string $table): array {
  try {
    $st=$pdo->prepare("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=?");
    $st->execute([$table]); return array_map('strval', array_column($st->fetchAll(), 'COLUMN_NAME'));
  } catch(Throwable $e){ return []; }
}

/* ===== 1) params ===== */
$roomUid = $_GET['room_uid'] ?? $_GET['uid'] ?? null;
if (!$roomUid) jerr(400,'missing room_uid');
$ttl  = max(10, (int)($_GET['ttl']  ?? 90));       // ثواني صلاحية الحضور
$mode = strtolower($_GET['mode'] ?? 'all');        // all | mic

/* ===== 2) db ===== */
$pdo = resolve_pdo();
if (!$pdo) jerr(500,'db_not_configured');

/* ===== 3) table names ===== */
$PREFIX = defined('TABLE_PREFIX') ? TABLE_PREFIX : '';
$TBL_MEMBERS  = $PREFIX.'room_members';            // جدولك الأساسي
$TBL_PRESENCE = defined('TBL_ROOM_PRESENCE') ? TBL_ROOM_PRESENCE : $PREFIX.'room_presence';
$TBL_MICS     = defined('TBL_ROOM_MICS')     ? TBL_ROOM_MICS     : $PREFIX.'room_mics';

/* ===== 4) choose presence table (members preferred) ===== */
$membersExists  = table_exists($pdo, $TBL_MEMBERS);
$presenceExists = table_exists($pdo, $TBL_PRESENCE);
$presenceTable  = $membersExists ? $TBL_MEMBERS : ($presenceExists ? $TBL_PRESENCE : null);

$debug = [
  'mode' => $mode,
  'ttl'  => $ttl,
  'members_exists'  => $membersExists,
  'presence_exists' => $presenceExists,
  'presence_table'  => $presenceTable,
];

$online = 0;
$source = 'none';

/* ===== 5) count via room_members / room_presence ===== */
if ($presenceTable) {
  $cols = list_columns($pdo, $presenceTable);

  // أعمدة محتملة
  $roomCol = current(array_intersect($cols, ['room_uid','room_id','roomId','rid'])) ?: 'room_uid';
  $userCol = current(array_intersect($cols, ['user_uid','user_id','uid','member_id'])) ?: (in_array('user_id',$cols)?'user_id':'user_uid');
  $seenCol = current(array_intersect($cols, ['last_seen','updated_at','heartbeat_at','ts'])) ?: 'last_seen';
  $speakerCol = current(array_intersect($cols, ['is_speaker','speaker','on_mic','isMic','mic','is_speaking']));
  $seatIdxCol = current(array_intersect($cols, ['seat_index','seat','slot','mic_index']));

  try {
    if ($mode === 'all') {
      // إجمالي الموجودين خلال آخر TTL ثانية
      $sql = "SELECT COUNT(DISTINCT `$userCol`) FROM `$presenceTable`
              WHERE `$roomCol` = :uid AND `$seenCol` >= (NOW() - INTERVAL :ttl SECOND)";
      $st = $pdo->prepare($sql);
      $st->bindValue(':uid',$roomUid);
      $st->bindValue(':ttl',$ttl,PDO::PARAM_INT);
      $st->execute();
      $online = (int)$st->fetchColumn();
      $source = ($presenceTable===$TBL_MEMBERS) ? 'members' : 'presence';
    } else { // mode = mic
      $micParts = [];
      if ($speakerCol) $micParts[] = "(`$speakerCol` IN (1,'1',TRUE))";
      if ($seatIdxCol) $micParts[] = "(`$seatIdxCol` IS NOT NULL)";
      if ($micParts) {
        $whereMic = implode(' OR ', $micParts);
        $sql = "SELECT COUNT(DISTINCT `$userCol`) FROM `$presenceTable`
                WHERE `$roomCol`=:uid AND `$seenCol` >= (NOW() - INTERVAL :ttl SECOND)
                  AND ($whereMic)";
        $st = $pdo->prepare($sql);
        $st->bindValue(':uid',$roomUid);
        $st->bindValue(':ttl',$ttl,PDO::PARAM_INT);
        $st->execute();
        $online = (int)$st->fetchColumn();
        $source = ($presenceTable===$TBL_MEMBERS) ? 'members_mic' : 'presence_mic';
      }
    }
  } catch (Throwable $e) {
    // لو صار خطأ SQL نرجع 0 ونترك السورس يتحدد لاحقًا
    $debug['presence_sql_error'] = true;
  }
}

/* ===== 6) fallback seats (room_mics) عند الحاجة لوضع mic فقط ===== */
if ($mode === 'mic' && $online === 0) {
  $seatsExists = table_exists($pdo, $TBL_MICS);
  $debug['seats_exists'] = $seatsExists;

  if ($seatsExists) {
    try {
      $cols = list_columns($pdo, $TBL_MICS);
      $roomCol = current(array_intersect($cols, ['room_uid','room_id','roomId','rid'])) ?: 'room_uid';
      // نحاول حالات أشغال مختلفة
      $parts = [];
      foreach (['user_id','uid','member_id','mic_user_id','speaker_uid'] as $c)
        if (in_array($c,$cols)) $parts[] = "(`$c` IS NOT NULL AND `$c` <> '' AND `$c` <> '0')";
      foreach (['status','state','mic_status'] as $c)
        if (in_array($c,$cols)) $parts[] = "(`$c` NOT IN ('free','idle','0','empty'))";
      foreach (['occupied','is_busy','busy','taken'] as $c)
        if (in_array($c,$cols)) $parts[] = "(`$c` IN (1,'1',TRUE))";

      if ($parts) {
        $sql = "SELECT COUNT(*) FROM `$TBL_MICS` WHERE `$roomCol`=:uid AND (".implode(' OR ', $parts).")";
        $st = $pdo->prepare($sql);
        $st->execute([':uid'=>$roomUid]);
        $online = (int)$st->fetchColumn();
        $source = 'seats';
      } else {
        $source = $source==='none' ? 'seats' : $source;
      }
    } catch (Throwable $e) {
      $source = $source==='none' ? 'seats' : $source;
    }
  }
}

/* ===== 7) output ===== */
echo json_encode([
  'ok' => true,
  'online' => (int)$online,
  'source' => $source,
] + $debug, JSON_UNESCAPED_UNICODE);
