<?php
// voicechat/api/room_membership.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/config.php';
$pdo = db();

// ====== helpers ======
function out($a, int $code=200){
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Authorization, Content-Type');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}
function in($k,$d=null){
  static $j=null;
  if ($j===null){
    $raw=file_get_contents('php://input');
    $j = $raw? json_decode($raw,true) : [];
    if(!is_array($j)) $j = [];
  }
  return $_GET[$k] ?? $_POST[$k] ?? ($j[$k] ?? $d);
}

// حوّل الروابط النسبية إلى مطلقة (يفيد إن كانت avatar_url بدون بروتوكول)
function absolutize_url(string $u): string {
  $u = trim($u);
  if ($u === '') return '';
  if (preg_match('~^https?://~i', $u)) return $u;
  return 'https://battle-party.com/' . ltrim($u, '/');
}

// ====== DB small helpers ======
function joined(PDO $pdo,string $room,int $uid): bool {
  if ($uid<=0) return false;
  $st=$pdo->prepare("SELECT 1 FROM join_room WHERE room_uid=? AND user_uid=? LIMIT 1");
  $st->execute([$room,$uid]);
  return (bool)$st->fetchColumn();
}
function count_members(PDO $pdo,string $room): int {
  $st=$pdo->prepare("SELECT COUNT(*) FROM join_room WHERE room_uid=?");
  $st->execute([$room]);
  return (int)$st->fetchColumn();
}
function state(PDO $pdo,string $room,int $uid): array {
  return ['joined'=>joined($pdo,$room,$uid),'count'=>count_members($pdo,$room)];
}

// ====== Params ======
$method   = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$room_uid = trim((string)in('room_uid',''));
$action   = strtolower((string)in('action',''));
if ($room_uid==='') out(['ok'=>0,'error'=>'room_uid required'],422);

// مستخدم اختياري للحالة فقط
$me_optional = bearer_user_id(); // users.id أو 0

// ========================= GET =========================
if ($method === 'GET') {
  if ($action === 'list') {
    // عامّة للقراءة
    $page = max(1,(int)in('page',1));
    $ps   = min(100,max(1,(int)in('page_size',30)));
    $off  = ($page-1)*$ps;

    // الاسم: نأخذ أول غير فارغ من مجموعة أعمدة، الصورة: نفس الفكرة
    $sql = "SELECT
              jr.user_uid AS uid,
              COALESCE(
                NULLIF(TRIM(u.username), ''),
                NULLIF(TRIM(u.userid),  ''),
                NULLIF(TRIM(u.name),    ''),
                NULLIF(TRIM(u.nickname),''),
                CONCAT('User ', u.id)
              ) AS name,
              COALESCE(
                NULLIF(TRIM(u.avatar_url),    ''),
                NULLIF(TRIM(u.avatar),        ''),
                NULLIF(TRIM(u.image_url),     ''),
                NULLIF(TRIM(u.image),         ''),
                NULLIF(TRIM(u.photo),         ''),
                NULLIF(TRIM(u.profile_pic),   ''),
                NULLIF(TRIM(u.profile_image), ''),
                NULLIF(TRIM(u.picture),       ''),
                NULLIF(TRIM(u.user_image),    ''),
                NULLIF(TRIM(u.img),           ''),
                ''
              ) AS avatar_url
            FROM join_room jr
            LEFT JOIN users u ON u.id = jr.user_uid
            WHERE jr.room_uid=?
            ORDER BY jr.id DESC
            LIMIT $ps OFFSET $off";
    $q = $pdo->prepare($sql);
    $q->execute([$room_uid]);

    $items = [];
    while ($r = $q->fetch(PDO::FETCH_ASSOC)) {
      $name = (string)($r['name'] ?? '');
      $ava  = (string)($r['avatar_url'] ?? '');
      if ($ava !== '') $ava = absolutize_url($ava);

      $items[] = [
        'uid'        => (string)($r['uid'] ?? ''),
        'name'       => $name,
        'avatar_url' => $ava,
      ];
    }
    out(['ok'=>1,'items'=>$items]);
  }

  // حالة الانضمام (بدون توكن ممكنة)
  $me = $me_optional;
  out(['ok'=>1,'data'=>state($pdo,$room_uid,$me)]);
}

// ========================= POST: join / leave =========================
$me = ($me_optional>0) ? $me_optional : require_user(); // تعديل يتطلب توكن

$joinFlag = in('join', null);
$doJoin   = ($joinFlag==1) || ($action==='join');

if ($doJoin) {
  $st = $pdo->prepare("INSERT IGNORE INTO join_room (room_uid,user_uid,created_at) VALUES (?,?,NOW())");
  $st->execute([$room_uid,$me]);
} else {
  $st = $pdo->prepare("DELETE FROM join_room WHERE room_uid=? AND user_uid=? LIMIT 1");
  $st->execute([$room_uid,$me]);
}

out(['ok'=>1,'data'=>state($pdo,$room_uid,$me)]);
