<?php
// voicechat/api/room_gifts_sum.php
require_once __DIR__ . '/config.php';

try {
  // Params
  $roomUid = trim($_GET['room_uid'] ?? $_POST['room_uid'] ?? '');
  $scope   = strtolower(trim($_GET['scope'] ?? $_POST['scope'] ?? 'week')); // day|week|all (افتراضي week)

  if ($roomUid === '') {
    json_out(['ok'=>false,'error'=>'missing_room_uid'], 400);
  }

  // حسبة النطاق الزمني
  $from = null;
  $now = time();
  if ($scope === 'day') {
    $from = date('Y-m-d 00:00:00');               // اليوم فقط
  } elseif ($scope === 'week') {
    $from = date('Y-m-d H:i:s', $now - 7*24*3600); // آخر 7 أيام
  } // else all => بدون شرط زمن

  $pdo = db();

  $sql = "SELECT 
            COALESCE(SUM(total_price),0) AS coins,
            COALESCE(SUM(quantity),0)    AS gifts
          FROM gift_transactions
          WHERE room_uid = :room_uid";
  $params = [':room_uid' => $roomUid];

  if ($from !== null) {
    $sql .= " AND created_at >= :from";
    $params[':from'] = $from;
  }

  $st = $pdo->prepare($sql);
  $st->execute($params);
  $row = $st->fetch() ?: ['coins'=>0,'gifts'=>0];

  json_out([
    'ok'    => true,
    'room'  => $roomUid,
    'scope' => $scope,
    'coins' => (int)$row['coins'],
    'gifts' => (int)$row['gifts'],
  ]);
} catch (Throwable $e) {
  json_out(['ok'=>false,'error'=>'server_error','message'=>$e->getMessage()], 500);
}
