<?php
// voicechat/api/room_gifts_rank.php
require_once __DIR__ . '/config.php';

try {
  // ===== Params (ندعم أسماء متعددة للتوافق مع الفلاتر) =====
  $roomUid = trim($_GET['room_uid'] ?? $_POST['room_uid'] ?? '');
  $roleRaw = $_GET['role']  ?? $_POST['role']  ?? $_GET['type']   ?? $_POST['type']   ?? 'senders';
  $scopeRaw= $_GET['scope'] ?? $_POST['scope'] ?? $_GET['period'] ?? $_POST['period'] ?? 'week';
  $limit   = (int)($_GET['limit'] ?? $_POST['limit'] ?? 50);
  if ($limit <= 0 || $limit > 200) $limit = 50;

  if ($roomUid === '') json_out(['ok'=>false,'error'=>'missing_room_uid'], 400);

  // normalize role
  $role = strtolower(trim($roleRaw));
  if (!in_array($role, ['senders','receivers'], true)) $role = 'senders';

  // normalize scope (ندعم daily/weekly)
  $scope = strtolower(trim($scopeRaw));
  if ($scope === 'daily')  $scope = 'day';
  if ($scope === 'weekly') $scope = 'week';
  if (!in_array($scope, ['day','week','all'], true)) $scope = 'week';

  // عمود التجميع حسب التاب
  $col = ($role === 'receivers') ? 'receiver_user_id' : 'sender_user_id';

  // النطاق الزمني
  $from = null;
  $now = time();
  if ($scope === 'day') {
    // اليوم (من منتصف الليل)
    $from = date('Y-m-d 00:00:00');
  } elseif ($scope === 'week') {
    // آخر 7 أيام (مطابق لما تستخدمه في الفلاتر)
    $from = date('Y-m-d H:i:s', $now - 7*24*3600);
  }

  $pdo = db();

  // where + params
  $where = "room_uid = :room_uid AND {$col} IS NOT NULL AND {$col} <> 0";
  $params = [':room_uid' => $roomUid];
  if ($from !== null) {
    $where .= " AND created_at >= :from";
    $params[':from'] = $from;
  }

  // ===== الاستعلام: نجمع ثم نJOIN على users لإحضار الاسم/الصورة/الـ userid =====
  $sql = "
    SELECT
      t.user_id,
      t.coins,
      t.gifts,
      COALESCE(u.userid, '')       AS userid,     -- 👈 نقرأ userid من جدول users
      COALESCE(u.username,'مستخدم') AS username,
      COALESCE(u.avatar_url,'')     AS avatar_url
    FROM (
      SELECT {$col} AS user_id,
             SUM(total_price) AS coins,
             SUM(quantity)    AS gifts
      FROM gift_transactions
      WHERE {$where}
      GROUP BY {$col}
      ORDER BY coins DESC
      LIMIT :lim
    ) AS t
    LEFT JOIN users u ON u.id = t.user_id
    ORDER BY t.coins DESC
  ";

  $st = $pdo->prepare($sql);
  foreach ($params as $k => $v) $st->bindValue($k, $v);
  $st->bindValue(':lim', $limit, PDO::PARAM_INT);
  $st->execute();

  $items = [];
  while ($r = $st->fetch()) {
    $items[] = [
      'user_id'    => (int)$r['user_id'],
      'userid'     => (string)$r['userid'],    // 👈 مفتاح واضح للفلاتر
      'username'   => (string)$r['username'],
      'avatar_url' => (string)$r['avatar_url'],
      'coins'      => (int)$r['coins'],
      'gifts'      => (int)$r['gifts'],
    ];
  }

  json_out([
    'ok'    => true,
    'room'  => $roomUid,
    'role'  => $role,   // senders|receivers
    'scope' => $scope,  // day|week|all
    'count' => count($items),
    'items' => $items,
  ]);
} catch (Throwable $e) {
  json_out(['ok'=>false,'error'=>'server_error','message'=>$e->getMessage()], 500);
}
