<?php
// voicechat/api/room_admins_remove.php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
  json_out(['ok'=>false,'error'=>'method_not_allowed'], 405);
}

$pdo = db();
$me  = require_user();
$j   = json_in();

$roomUid   = trim((string)($j['room_uid'] ?? ''));
$targetUid = trim((string)($j['target_uid'] ?? ''));

if ($roomUid === '' || $targetUid === '') {
  json_out(['ok'=>false,'error'=>'missing_params'], 400);
}

// تحقق أني المالك
$st = $pdo->prepare("SELECT owner_uid FROM rooms WHERE uid=? LIMIT 1");
$st->execute([$roomUid]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if (!$row || $row['owner_uid'] !== $me) {
  json_out(['ok'=>false,'error'=>'forbidden'], 403);
}

$st = $pdo->prepare("DELETE FROM room_admins WHERE room_uid=? AND admin_uid=?");
$st->execute([$roomUid, $targetUid]);

json_out(['ok'=>true]);
