<?php
// backend/api/page_get.php
declare(strict_types=1);
require __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *'); // عدّلها لو عندك نطاقات محددة

$slug = $_GET['slug'] ?? '';
if (!preg_match('/^[a-z0-9\-]+$/', $slug)) {
  http_response_code(400);
  echo json_encode(['error' => 'bad_slug']);
  exit;
}

try {
  $pdo = db();
  $st = $pdo->prepare("SELECT slug, title, content_html, updated_at FROM static_pages WHERE slug=? LIMIT 1");
  $st->execute([$slug]);
  $row = $st->fetch();
  if (!$row) {
    http_response_code(404);
    echo json_encode(['error' => 'not_found']);
    exit;
  }
  echo json_encode($row, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'server_error']);
}
