<?php
// voicechat/api/notefirebase/fcm_unregister.php
declare(strict_types=1);

require __DIR__ . '/../config.php'; // config.php داخل voicechat/api

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function out($arr, int $code=200){ http_response_code($code); echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$auth = function_exists('require_auth') ? require_auth() : null;
if (!$auth || !($auth['uid'] ?? '')) out(['ok'=>false,'error'=>'unauthorized'], 401);
$user_uid = (string)$auth['uid'];

$raw   = json_decode(file_get_contents('php://input'), true) ?: [];
$token = trim((string)($raw['token'] ?? ''));

if ($token === '') out(['ok'=>false,'error'=>'missing_token'], 400);

$pdo = db();
$st = $pdo->prepare("DELETE FROM fcm_tokens WHERE token=? AND user_uid=?");
$st->execute([$token, $user_uid]);

out(['ok'=>true]);
