<?php
require_once __DIR__ . '/../config.php';

try {
  // يتطلب JWT صالح
  $uid = require_user();
  $pdo = db();

  $post_id = (int)($_POST['post_id'] ?? 0);
  if ($post_id <= 0) {
    respond(['ok' => 0, 'error' => 'post_required'], 422);
  }

  // تأكد أن المنشور موجود
  $chk = $pdo->prepare('SELECT 1 FROM moment_posts WHERE id = ?');
  $chk->execute([$post_id]);
  if (!$chk->fetchColumn()) {
    respond(['ok' => 0, 'error' => 'post_not_found'], 404);
  }

  // هل هناك إعجاب مسبقاً؟
  $q = $pdo->prepare('SELECT 1 FROM moment_post_likes WHERE post_id = ? AND user_id = ?');
  $q->execute([$post_id, $uid]);
  $hasLike = (bool)$q->fetchColumn();

  $liked = false;

  if ($hasLike) {
    // إزالة الإعجاب
    $d = $pdo->prepare('DELETE FROM moment_post_likes WHERE post_id = ? AND user_id = ?');
    $d->execute([$post_id, $uid]);
    $liked = false;
  } else {
    // إضافة إعجاب (مع معالجة التكرار لو فيه UNIQUE(post_id,user_id))
    try {
      $i = $pdo->prepare('INSERT INTO moment_post_likes (post_id, user_id, liked_at) VALUES (?, ?, NOW())');
      $i->execute([$post_id, $uid]);
      $liked = true;
    } catch (Throwable $e) {
      // في حال UNIQUE KEY موجودة وتم الإدخال من سباق حالات، اعتبره مُعجب
      $liked = true;
    }
  }

  // إجمالي الإعجابات بعد العملية
  $c = $pdo->prepare('SELECT COUNT(*) FROM moment_post_likes WHERE post_id = ?');
  $c->execute([$post_id]);
  $count = (int)$c->fetchColumn();

  respond(['ok' => 1, 'liked' => $liked ? 1 : 0, 'likes_count' => $count], 200);

} catch (Throwable $e) {
  respond(['ok' => 0, 'error' => $e->getMessage()], 500);
}
