<?php
require_once __DIR__ . '/../config.php';

try {
  // يتطلب JWT صالح
  $uid = require_user();
  $pdo = db();

  $post_id = (int)($_POST['post_id'] ?? 0);
  $text    = trim((string)($_POST['text'] ?? ''));

  if ($post_id <= 0) {
    respond(['ok' => 0, 'error' => 'post_required'], 422);
  }
  if ($text === '') {
    respond(['ok' => 0, 'error' => 'text_required'], 422);
  }
  // حد أعلى اختياري لطول التعليق
  $len = function_exists('mb_strlen') ? mb_strlen($text, 'UTF-8') : strlen($text);
  if ($len > 2000) {
    respond(['ok' => 0, 'error' => 'text_too_long'], 422);
  }

  // تأكد أن البوست موجود
  $chk = $pdo->prepare('SELECT 1 FROM moment_posts WHERE id = ?');
  $chk->execute([$post_id]);
  if (!$chk->fetchColumn()) {
    respond(['ok' => 0, 'error' => 'post_not_found'], 404);
  }

  // إضافة التعليق
  $ins = $pdo->prepare('INSERT INTO moment_comments (post_id, user_id, text, created_at) VALUES (?, ?, ?, NOW())');
  $ins->execute([$post_id, $uid, $text]);
  $cid = (int)$pdo->lastInsertId();

  // اجلب التعليق المضاف + معلومات المستخدم
  $q = $pdo->prepare("
    SELECT
      c.id,
      c.post_id,
      c.user_id,
      c.text,
      c.created_at,
      u.username,
      COALESCE(u.avatar_url,'') AS avatar_url
    FROM moment_comments c
    JOIN users u ON u.id = c.user_id
    WHERE c.id = ?
  ");
  $q->execute([$cid]);
  $comment = $q->fetch();

  // إجمالي التعليقات بعد الإضافة (اختياري مفيد للواجهة)
  $cnt = $pdo->prepare('SELECT COUNT(*) FROM moment_comments WHERE post_id = ?');
  $cnt->execute([$post_id]);
  $comments_count = (int)$cnt->fetchColumn();

  respond([
    'ok'              => 1,
    'comment'         => $comment,
    'comments_count'  => $comments_count,
  ], 200);

} catch (Throwable $e) {
  respond(['ok' => 0, 'error' => $e->getMessage()], 500);
}
