<?php
// voicechat/api/moment/create.php
declare(strict_types=1);

require_once __DIR__ . '/_bootstrap.php'; // ← مهم: يجلب require_user() الصحيح و respond()

try {
  // يتطلب JWT صالح — يرجع users.id (رقمي)
  $uid = require_user();
  $pdo = db();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // إدخال
  $category_id  = (int)($_POST['category_id'] ?? 0);
  $content_text = trim((string)($_POST['content_text'] ?? ''));

  if ($category_id <= 0) respond(['ok'=>0,'error'=>'category_required'], 422);
  if ($content_text === '' && empty($_FILES['image'])) {
    respond(['ok'=>0,'error'=>'empty_post'], 422);
  }

  // تأكيد التصنيف
  $chk = $pdo->prepare('SELECT 1 FROM moment_categories WHERE id=? LIMIT 1');
  $chk->execute([$category_id]);
  if (!$chk->fetchColumn()) respond(['ok'=>0,'error'=>'category_not_found'], 422);

  // حفظ الصورة (اختياري)
  $image_url = null;
  if (!empty($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
    // مسارات من config.php (عرّفها إن لم تكن موجودة)
    $FILES_MOMENT_BASE_DIR = $GLOBALS['FILES_MOMENT_BASE_DIR'] ?? (dirname(__DIR__) . '/files/moment');
    $FILES_MOMENT_BASE_URL = $GLOBALS['FILES_MOMENT_BASE_URL'] ?? 'https://battle-party.com/voicechat/files/moment';

    @mkdir($FILES_MOMENT_BASE_DIR, 0775, true);
    $ym  = date('Y/m');
    $dir = rtrim($FILES_MOMENT_BASE_DIR, '/') . "/$ym";
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    if (!is_dir($dir) || !is_writable($dir)) {
      respond(['ok'=>0,'error'=>'upload_dir_not_writable'], 500);
    }

    $orig = $_FILES['image']['name'] ?? 'img.jpg';
    $ext  = strtolower(pathinfo($orig, PATHINFO_EXTENSION) ?: 'jpg');
    $allowed = ['jpg','jpeg','png','gif','webp'];
    if (!in_array($ext, $allowed, true)) $ext = 'jpg';

    $name = uniqid('p', true) . '.' . $ext;
    $dest = "$dir/$name";

    if (!move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {
      respond(['ok'=>0,'error'=>'upload_failed'], 500);
    }

    $image_url = rtrim($FILES_MOMENT_BASE_URL, '/') . "/$ym/$name";
  }

  // إنشاء المنشور
  $st = $pdo->prepare(
    'INSERT INTO moment_posts (user_id, category_id, content_text, image_url) VALUES (?,?,?,?)'
  );
  $st->execute([$uid, $category_id, $content_text, $image_url]);
  $id = (int)$pdo->lastInsertId();

  // جلب المنشور للرد — اجعلها LEFT JOIN وفِل باك مضمون
  $p = $pdo->prepare(
    'SELECT
       p.id, p.user_id, p.category_id, p.content_text, p.image_url, p.created_at,
       COALESCE(u.username,"") AS username,
       COALESCE(u.avatar_url,"") AS avatar_url,
       (SELECT COUNT(*) FROM moment_post_likes l WHERE l.post_id=p.id) AS likes_count,
       (SELECT COUNT(*) FROM moment_comments   c WHERE c.post_id=p.id) AS comments_count,
       ((SELECT COUNT(*) FROM moment_post_likes l2 WHERE l2.post_id=p.id AND l2.user_id=?) > 0) AS liked_by_me
     FROM moment_posts p
     LEFT JOIN users u ON u.id = p.user_id
     WHERE p.id=?'
  );
  $p->execute([$uid, $id]);
  $post = $p->fetch(PDO::FETCH_ASSOC);

  if (!$post) {
    // fallback آمن حتى لا نعيد post=false
    $post = [
      'id'             => $id,
      'user_id'        => $uid,
      'category_id'    => $category_id,
      'content_text'   => $content_text,
      'image_url'      => $image_url ?? '',
      'created_at'     => date('Y-m-d H:i:s'),
      'username'       => '',
      'avatar_url'     => '',
      'likes_count'    => 0,
      'comments_count' => 0,
      'liked_by_me'    => false,
    ];
  }

  respond(['ok'=>1,'post'=>$post], 200);

} catch (Throwable $e) {
  // أثناء التطوير اطبع الرسالة، في الإنتاج أزل msg
  respond(['ok'=>0,'error'=>'server_error','msg'=>$e->getMessage()], 500);
}
