<?php
// voicechat/api/room_members.php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
  http_response_code(204);
  exit;
}

try {
  $pdo = db();

  // GET: ?room_uid=...  -> {ok, count, joined}
  if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $room_uid = trim($_GET['room_uid'] ?? '');
    if ($room_uid === '') json_out(['ok'=>false,'error'=>'missing_room_uid'], 400);

    // نحاول استخراج uid من التوكين لمعرفة joined
    $uid = bearer_user_id(); // من config.php (قد يعيد 0 إذا لا يوجد توكين)
    $uid_str = $uid ? (string)$uid : '';

    // العدد
    $st = $pdo->prepare('SELECT COUNT(*) AS c FROM room_members WHERE room_uid=?');
    $st->execute([$room_uid]);
    $count = (int)($st->fetch()['c'] ?? 0);

    $joined = false;
    if ($uid_str !== '') {
      $st = $pdo->prepare('SELECT 1 FROM room_members WHERE room_uid=? AND user_uid=? LIMIT 1');
      $st->execute([$room_uid, $uid_str]);
      $joined = (bool)$st->fetchColumn();
    }

    json_out(['ok'=>true, 'count'=>$count, 'joined'=>$joined]);
  }

  // POST: {room_uid, join:1|0}
  $in = json_in();
  $room_uid = trim($in['room_uid'] ?? '');
  $joinFlag = (int)($in['join'] ?? -1);
  if ($room_uid === '' || ($joinFlag !== 0 && $joinFlag !== 1)) {
    json_out(['ok'=>false,'error'=>'bad_params'], 400);
  }

  // يجب أن يكون المستخدم مسجلاً
  $uid = require_user(); // يرمي 401 إذا مافيه توكين
  $uid_str = (string)$uid;

  if ($joinFlag === 1) {
    // انضمام
    $st = $pdo->prepare('INSERT IGNORE INTO room_members (room_uid, user_uid) VALUES (?, ?)');
    $st->execute([$room_uid, $uid_str]);
  } else {
    // إلغاء انضمام
    $st = $pdo->prepare('DELETE FROM room_members WHERE room_uid=? AND user_uid=?');
    $st->execute([$room_uid, $uid_str]);
  }

  // أعِد الحالة والعدّاد
  $st = $pdo->prepare('SELECT COUNT(*) AS c FROM room_members WHERE room_uid=?');
  $st->execute([$room_uid]);
  $count = (int)($st->fetch()['c'] ?? 0);

  $joined = ($joinFlag === 1);
  json_out(['ok'=>true, 'count'=>$count, 'joined'=>$joined]);

} catch (Throwable $e) {
  json_out(['ok'=>false,'error'=>$e->getMessage()], 500);
}
