<?php
// voicechat/api/friends.php
require_once __DIR__ . '/config.php';

$me = require_user();           // يرمي 401 إذا لم يكن مسجلاً
$myId = (int)$me['uid'];        // من jwt payload (راجع require_auth في config.php)

// استخرج المسار الفرعي (/friends/status مثلا)
$path = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$action = '';
if (preg_match('~(?:^|/)friends(?:\.php)?(?:/([^/]+))?~i', $path, $m)) {
  $action = strtolower($m[1] ?? '');
}
if (!$action) {
  // احتياطي: ?action=status
  $action = strtolower($_GET['action'] ?? '');
}

$method = strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');

function norm_pair(int $a, int $b){ return ($a <= $b) ? [$a,$b] : [$b,$a]; }

function get_friend_row(int $a, int $b){
  [$u1,$u2] = norm_pair($a,$b);
  $pdo = db();
  $st = $pdo->prepare('SELECT * FROM friends WHERE uid1=? AND uid2=? LIMIT 1');
  $st->execute([$u1,$u2]);
  return $st->fetch() ?: null;
}

function create_pending(int $me, int $peer){
  [$u1,$u2] = norm_pair($me,$peer);
  $pdo = db();
  $st = $pdo->prepare('
    INSERT INTO friends (uid1,uid2,status,requested_by,created_at,updated_at)
    VALUES (?,?,?,?,NOW(),NOW())
    ON DUPLICATE KEY UPDATE
      status=VALUES(status),
      requested_by=VALUES(requested_by),
      updated_at=NOW()
  ');
  $st->execute([$u1,$u2,'pending',$me]);
}

function set_status(int $a,int $b,string $status){
  [$u1,$u2] = norm_pair($a,$b);
  $pdo = db();
  $st = $pdo->prepare('UPDATE friends SET status=?, updated_at=NOW() WHERE uid1=? AND uid2=?');
  $st->execute([$status,$u1,$u2]);
}

function delete_friend_row(int $a,int $b){
  [$u1,$u2] = norm_pair($a,$b);
  $pdo = db();
  $st = $pdo->prepare('DELETE FROM friends WHERE uid1=? AND uid2=?');
  $st->execute([$u1,$u2]);
}

if ($action === 'status' && $method === 'GET') {
  $peerUid = (int)($_GET['peer_uid'] ?? 0);
  if ($peerUid <= 0) json_out(['ok'=>false,'error'=>'bad_peer_uid'], 400);

  $row = get_friend_row($myId, $peerUid);
  $status = 'none';
  $direction = null;

  if ($row) {
    if ($row['status'] === 'accepted') {
      $status = 'accepted';
    } elseif ($row['status'] === 'pending') {
      if ((int)$row['requested_by'] === $myId) $status = 'pending_out';
      else $status = 'pending_in';
    } elseif ($row['status'] === 'blocked') {
      $status = 'blocked';
    }
  }

  json_out([
    'ok' => true,
    'status' => $status,
    'can_chat' => ($status === 'accepted'),
  ]);
}

if ($action === 'request' && $method === 'POST') {
  $in = json_in();
  $peerUid = (int)($in['peer_uid'] ?? 0);
  if ($peerUid <= 0 || $peerUid === $myId) json_out(['ok'=>false,'error'=>'bad_peer_uid'], 400);

  $row = get_friend_row($myId, $peerUid);
  if ($row) {
    if ($row['status'] === 'accepted') json_out(['ok'=>true,'status'=>'accepted']);
    if ($row['status'] === 'pending') {
      // لو كان الطلب خارج مني بالفعل اعتبرها نجاح
      if ((int)$row['requested_by'] === $myId) json_out(['ok'=>true,'status'=>'pending_out']);
      // طلب عكسي موجود — نعتبرها قبول فوري
      set_status($myId,$peerUid,'accepted');
      json_out(['ok'=>true,'status'=>'accepted']);
    }
  }

  create_pending($myId, $peerUid);
  json_out(['ok'=>true,'status'=>'pending_out']);
}

if ($action === 'respond' && $method === 'POST') {
  $in = json_in();
  $peerUid = (int)($in['peer_uid'] ?? 0);
  $accept  = (bool)($in['accept'] ?? false);
  if ($peerUid <= 0 || $peerUid === $myId) json_out(['ok'=>false,'error'=>'bad_peer_uid'], 400);

  $row = get_friend_row($myId, $peerUid);
  if (!$row || $row['status'] !== 'pending') {
    json_out(['ok'=>false,'error'=>'no_pending_request'], 400);
  }

  // لا يقبل/يرفض إلا الطرف المستقبل (وليس مرسل الطلب)
  if ((int)$row['requested_by'] === $myId) {
    json_out(['ok'=>false,'error'=>'cannot_respond_own_request'], 400);
  }

  if ($accept) {
    set_status($myId,$peerUid,'accepted');
    json_out(['ok'=>true,'status'=>'accepted']);
  } else {
    delete_friend_row($myId,$peerUid);
    json_out(['ok'=>true,'status'=>'none']);
  }
}

// أي شيء آخر
json_out(['ok'=>false,'error'=>'not_found'], 404);
