<?php
// voicechat/api/files/avatar/list.php
declare(strict_types=1);

// تحميل الكونفيج (CORS/JSON helpers)
require_once dirname(__DIR__, 2) . '/config.php';

// المجلد الفعلي للصور هو نفس مجلد هذا السكربت
$AVATAR_DIR = __DIR__;

// بناء الـ BASE URL من مسار السكربت نفسه
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'localhost';

// dirname('/voicechat/api/files/avatar/list.php') => '/voicechat/api/files/avatar'
$script = $_SERVER['SCRIPT_NAME'] ?? '/';
$dirUrl = rtrim(str_replace('\\', '/', dirname($script)), '/');
$AVATAR_BASE_URL = $scheme . '://' . $host . $dirUrl;

// خيارات اختيارية عبر GET
$shuffle = isset($_GET['shuffle']) && $_GET['shuffle'] !== '0';
$limit   = isset($_GET['limit'])   ? max(0, (int)$_GET['limit']) : 0;
$prefix  = isset($_GET['prefix'])  ? (string)$_GET['prefix']     : '';

// تحقق من المجلد
if (!is_dir($AVATAR_DIR) || !is_readable($AVATAR_DIR)) {
  json_out(['ok'=>false, 'error'=>'avatar_dir_not_readable', 'dir'=>$AVATAR_DIR], 500);
}

$allowExt = ['jpg','jpeg','png','webp','gif'];
$files = @scandir($AVATAR_DIR) ?: [];
$images = [];

foreach ($files as $f) {
  if ($f === '.' || $f === '..') continue;
  if ($f[0] === '.') continue; // اخفِ الملفات المخفية

  $path = $AVATAR_DIR . '/' . $f;
  if (!is_file($path) || !is_readable($path)) continue;

  $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
  if (!in_array($ext, $allowExt, true)) continue;

  if ($prefix !== '' && stripos($f, $prefix) !== 0) continue;

  $images[] = $AVATAR_BASE_URL . '/' . rawurlencode($f);
}

if (!$shuffle) {
  natcasesort($images);
  $images = array_values($images);
} else {
  shuffle($images);
}

if ($limit > 0 && count($images) > $limit) {
  $images = array_slice($images, 0, $limit);
}

// كاش بسيط للمتصفح (5 دقائق)
header('Cache-Control: public, max-age=300');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
echo json_encode($images, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
exit;
