<?php
// voicechat/api/family/members.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

function out($a){ echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function g($k,$d=null){ return $_GET[$k] ?? $_POST[$k] ?? $d; }

$pdo = db();

$fid    = (int) g('family_id', 0);
$limit  = max(1, (int) g('limit', 20));
$page   = max(1, (int) g('page', 1));
$offset = ($page - 1) * $limit;

if ($fid <= 0) out(['ok'=>false,'error'=>'missing_family_id']);

try {
  $members = [];
  // نجرب JOIN على users.id
  try {
    $sql = "SELECT m.user_uid, m.role, m.joined_at,
                   COALESCE(u.username, '')   AS username,
                   COALESCE(u.avatar_url, '') AS avatar_url
            FROM family_members m
            LEFT JOIN users u ON u.id = m.user_uid
            WHERE m.family_id = ?
            ORDER BY (m.role='owner') DESC, m.joined_at ASC
            LIMIT {$limit} OFFSET {$offset}";
    $q = $pdo->prepare($sql);
    $q->execute([$fid]);
    $members = $q->fetchAll(PDO::FETCH_ASSOC);
  } catch (Throwable $e) {
    // fallback بدون JOIN
    $sql = "SELECT user_uid, role, joined_at
            FROM family_members
            WHERE family_id = ?
            ORDER BY (role='owner') DESC, joined_at ASC
            LIMIT {$limit} OFFSET {$offset}";
    $q = $pdo->prepare($sql);
    $q->execute([$fid]);
    $members = $q->fetchAll(PDO::FETCH_ASSOC);
  }

  out(['ok'=>true, 'items'=>$members, 'page'=>$page, 'limit'=>$limit]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'server_error','msg'=>$e->getMessage()]);
}
