<?php
// voicechat/api/family/me.php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';

function inparam($k, $d=null){ return $_GET[$k] ?? $_POST[$k] ?? $d; }

$pdo = db();
$authUid = bearer_user_id(); // 0 إذا لا يوجد توكن
$familyId = (int) inparam('family_id', 0);
$role = null;

// لو لم تصل family_id نحاول إيجادها من عضوية المستخدم
if ($familyId <= 0 && $authUid > 0) {
  $st = $pdo->prepare("SELECT family_id, role FROM family_members WHERE user_uid=? LIMIT 1");
  $st->execute([$authUid]);
  if ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    $familyId = (int)$row['family_id'];
    $role = $row['role'] ?? null;
  }
}

if ($familyId <= 0) {
  // لا توجد عائلة محددة ولا عضوية
  json_out(['ok'=>true, 'family_id'=>null, 'role'=>null, 'members'=>0, 'capacity'=>2000]);
}

// معلومات العائلة (نجرب أكثر من جدول)
$name = '';
$badgeUrl = '';
$bannerUrl = '';
$slogan = '';
$capacity = 2000;

foreach (['families','family'] as $tbl) {
  try {
    $sql = "SELECT
              id,
              COALESCE(name,'')          AS name,
              COALESCE(badge_url, logo_url, '') AS badge_url,
              COALESCE(banner_url,'')    AS banner_url,
              COALESCE(slogan, announcement, '') AS slogan,
              COALESCE(capacity, max_members, 2000) AS capacity
            FROM {$tbl}
            WHERE id = ?
            LIMIT 1";
    $st = $pdo->prepare($sql);
    $st->execute([$familyId]);
    if ($f = $st->fetch(PDO::FETCH_ASSOC)) {
      $name      = (string)$f['name'];
      $badgeUrl  = (string)$f['badge_url'];
      $bannerUrl = (string)$f['banner_url'];
      $slogan    = (string)$f['slogan'];
      $capacity  = (int)$f['capacity'];
      if ($capacity <= 0) $capacity = 2000;
      break;
    }
  } catch (Throwable $e) { /* تجاهل لو الجدول غير موجود */ }
}

// عدّاد الأعضاء
$st = $pdo->prepare("SELECT COUNT(*) FROM family_members WHERE family_id=?");
$st->execute([$familyId]);
$members = (int)$st->fetchColumn();

// إن كان لدينا توكن لكن role لا تزال null و المستخدم عضو في هذه العائلة، اجلب الدور
if ($authUid > 0 && $role === null) {
  $st = $pdo->prepare("SELECT role FROM family_members WHERE family_id=? AND user_uid=? LIMIT 1");
  $st->execute([$familyId, $authUid]);
  $role = $st->fetchColumn() ?: null;
}

json_out([
  'ok'         => true,
  'family_id'  => $familyId,
  'name'       => $name,
  'badge_url'  => $badgeUrl,
  'banner_url' => $bannerUrl,
  'slogan'     => $slogan,
  'members'    => $members,
  'capacity'   => $capacity,
  'role'       => $role,
]);
