<?php
// voicechat/api/family/details.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

function out($a){ echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function g($k,$d=null){ return $_GET[$k] ?? $_POST[$k] ?? $d; }
function bearer_token(){
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
  if (preg_match('/Bearer\s+(.+)/i', $h, $m)) return trim($m[1]);
  return null;
}

// أصل الدومين الحالي (https + الدومين + المنفذ إن وجد)
function origin(){
  $sch = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? 'localhost');
  return $sch . '://' . $host;
}

// تحويل أي رابط لصيغة مطلقة وصحيحة
function abs_url($s){
  if (!$s) return '';
  $s = trim((string)$s);
  if ($s === '') return '';
  if (strpos($s, '//') === 0) return 'https:' . $s;            // //cdn...
  if (stripos($s, 'http://') === 0) return 'https://' . substr($s, 7); // http -> https
  if (stripos($s, 'https://') === 0) return $s;                 // جاهز
  if ($s[0] !== '/') $s = '/' . $s;                             // مسار نسبي -> أضف /
  return origin() . $s;
}

function current_user_uid(PDO $pdo){
  $t = bearer_token();
  if ($t) {
    try{
      $q = $pdo->prepare("SELECT uid FROM users WHERE api_token = ? LIMIT 1");
      $q->execute([$t]);
      if ($r = $q->fetch(PDO::FETCH_ASSOC)) return $r['uid'];
    }catch(Throwable $e){}
    try{
      $q = $pdo->prepare("SELECT user_uid FROM user_tokens WHERE token = ? AND revoked = 0 ORDER BY id DESC LIMIT 1");
      $q->execute([$t]);
      if ($r = $q->fetch(PDO::FETCH_ASSOC)) return $r['user_uid'];
    }catch(Throwable $e){}
  }
  return g('user_uid');
}

$fid = (int) g('family_id', 0);
if ($fid <= 0) out(['ok'=>false,'error'=>'missing_family_id']);

// ✅ مهم: عرِّف $pdo
$pdo = db();

try{
  // معلومات العائلة (+ السعة إن موجودة)
  $q = $pdo->prepare("SELECT id, owner_uid, name, badge_url, cover_url,
                             COALESCE(capacity, max_members) AS capacity,
                             created_at
                      FROM families
                      WHERE id = ? LIMIT 1");
  $q->execute([$fid]);
  $fam = $q->fetch(PDO::FETCH_ASSOC);
  if (!$fam) out(['ok'=>false,'error'=>'family_not_found']);

  // اسم/صورة المالك (اختياري)
  $owner = null;
  try{
    $q = $pdo->prepare("SELECT uid, username, avatar_url FROM users WHERE uid = ? LIMIT 1");
    $q->execute([$fam['owner_uid']]);
    $owner = $q->fetch(PDO::FETCH_ASSOC);
    if ($owner && !empty($owner['avatar_url'])) {
      $owner['avatar_url'] = abs_url($owner['avatar_url']);
    }
  }catch(Throwable $e){}

  // عدد الأعضاء
  $q = $pdo->prepare("SELECT COUNT(*) AS c FROM family_members WHERE family_id = ?");
  $q->execute([$fid]);
  $cnt = (int)($q->fetch(PDO::FETCH_ASSOC)['c'] ?? 0);

  // هل المستخدم عضو؟
  $me_uid = current_user_uid($pdo);
  $is_member = false;
  if ($me_uid) {
    $q = $pdo->prepare("SELECT 1 FROM family_members WHERE family_id = ? AND user_uid = ? LIMIT 1");
    $q->execute([$fid, $me_uid]);
    $is_member = (bool)$q->fetchColumn();
  }

  // إصلاح الروابط لتكون مطلقة
  $badge = abs_url($fam['badge_url'] ?? '');
  $cover = abs_url($fam['cover_url'] ?? '');

  // سعة افتراضية 2000 عند عدم توفرها
  $capacity = (int)($fam['capacity'] ?? 0);
  if ($capacity <= 0) $capacity = 2000;

  out([
    'ok' => true,
    'family' => [
      'id'          => (int)$fam['id'],
      'name'        => (string)$fam['name'],
      'badge_url'   => $badge,
      'cover_url'   => $cover,
      // تكرار banner_url للتوافق مع العميل
      'banner_url'  => $cover,
      'owner_uid'   => $fam['owner_uid'],
      'owner'       => $owner,
      'capacity'    => $capacity,  // لتقرؤها من fam['capacity']
      'members'     => $cnt,       // لتقرؤها من fam['members'] إذا احتجت
      'created_at'  => $fam['created_at'],
    ],
    'members_count' => $cnt,       // لتقرؤها من raw['members_count']
    'is_member'     => $is_member,
  ]);

}catch(Throwable $e){
  out(['ok'=>false,'error'=>'server_error','msg'=>$e->getMessage()]);
}
