<?php
// voicechat/api/emojis.php
declare(strict_types=1);

require __DIR__ . '/config.php';  // نفس الملف الذي يحتوي دالة db() والهيدرز

try {
  $pdo = db();
} catch (Throwable $e) {
  json_out(['ok' => false, 'error' => 'db_connect_failed: '.$e->getMessage()], 500);
}

// لو لم تكن موجودة في config.php
if (!function_exists('full_url')) {
  function full_url(?string $p): ?string {
    if (!$p) return null;
    if (preg_match('~^https?://~i', $p)) return $p;
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $scheme.'://'.$host.(str_starts_with($p,'/') ? $p : '/'.$p);
  }
}

$action = $_GET['action'] ?? '';

// ====================== الفئات (اختياري) ======================
if ($action === 'categories') {
  $st = $pdo->query("SELECT id, name, COALESCE(icon_url,'') AS icon_url, sort_order
                     FROM emoji_categories
                     ORDER BY sort_order, id");
  $cats = [];
  while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
    $cats[] = [
      'id'         => (int)$r['id'],
      'name'       => (string)$r['name'],
      'icon_url'   => full_url($r['icon_url']),
      'sort_order' => (int)$r['sort_order'],
    ];
  }
  // يعيد بالمفاتيح التي يفهمها الكلاينت
  json_out(['ok'=>true, 'items'=>$cats, 'categories'=>$cats]);
}

// ====================== قائمة الإيموجي ======================
$categoryId = isset($_GET['category_id']) ? (int)$_GET['category_id'] : 0;
if ($categoryId <= 0) {
  json_out(['ok'=>false, 'error'=>'missing category_id'], 400);
}

$page     = max(1, (int)($_GET['page'] ?? 1));
$pageSize = min(100, max(1, (int)($_GET['page_size'] ?? 24)));
$offset   = ($page - 1) * $pageSize;

$st = $pdo->prepare("SELECT id, category_id, name, image_url, animated, sort_order
                     FROM emojis
                     WHERE category_id = ?
                     ORDER BY sort_order, id
                     LIMIT ? OFFSET ?");
$st->bindValue(1, $categoryId, PDO::PARAM_INT);
$st->bindValue(2, $pageSize,   PDO::PARAM_INT);
$st->bindValue(3, $offset,     PDO::PARAM_INT);
$st->execute();

$items = [];
while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
  $items[] = [
    'id'          => (int)$r['id'],
    'category_id' => (int)$r['category_id'],
    'name'        => (string)$r['name'],
    'image_url'   => full_url($r['image_url']), // مهم: URL كامل
    'animated'    => (bool)$r['animated'],
    'sort_order'  => (int)$r['sort_order'],
  ];
}

// has_more يكفي أن يكون true لو الصفحة ممتلئة
$hasMore = count($items) === $pageSize;

json_out(['ok'=>true, 'items'=>$items, 'has_more'=>$hasMore, 'page'=>$page]);
