<?php
// voicechat/api/emoji_send.php
declare(strict_types=1);
require __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function jfail($msg, $code=400, $extra=[]) {
  http_response_code($code);
  echo json_encode(['ok'=>false,'error'=>$msg] + $extra, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}
function jok($data=[]) {
  echo json_encode(['ok'=>true] + $data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

function has_column(PDO $pdo, string $table, string $col): bool {
  try {
    $st = $pdo->prepare("SELECT 1 FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?");
    $st->execute([$table, $col]);
    return (bool)$st->fetchColumn();
  } catch (Throwable $e) { return false; }
}

try {
  // مطالبات التوكن: uid نصّي + id رقمي (لو موجود)
  $claims  = require_auth();
  $userUid = trim((string)($claims['uid'] ?? '')); // مثل Firebase UID
  $userId  = (int)($claims['id']  ?? 0);          // users.id إن كنت تولّده في exchange

  // بارامترات
  $in = $_POST; if (!$in) $in = $_GET; if (!$in) $in = json_in();
  $roomUid = trim((string)($in['room_uid'] ?? ''));
  $emojiId = (int)($in['emoji_id'] ?? 0);
  if ($roomUid === '' || $emojiId <= 0) jfail('missing_params', 422);

  $pdo = db();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // ===== تحقق أنه على المايك =====
  $onMic = false;
  if ($userId > 0 && has_column($pdo, 'room_mics', 'user_id')) {
    $st = $pdo->prepare('SELECT 1 FROM room_mics WHERE room_uid=? AND user_id=? LIMIT 1');
    $st->execute([$roomUid, $userId]);
    $onMic = (bool)$st->fetchColumn();
  }
  if (!$onMic && $userUid !== '' && has_column($pdo, 'room_mics', 'user_uid')) {
    $st = $pdo->prepare('SELECT 1 FROM room_mics WHERE room_uid=? AND user_uid=? LIMIT 1');
    $st->execute([$roomUid, $userUid]);
    $onMic = (bool)$st->fetchColumn();
  }
  if (!$onMic) jfail('not_on_mic', 403, ['used_id'=>$userId, 'used_uid'=>$userUid]);

  // ===== إدراج الحدث مع الأعمدة المتوفرة فقط =====
  $cols = ['room_uid','emoji_id'];
  $vals = [$roomUid, $emojiId];

  if (has_column($pdo, 'room_emoji_events', 'user_id') && $userId > 0) {
    $cols[] = 'user_id'; $vals[] = $userId;
  }
  if (has_column($pdo, 'room_emoji_events', 'user_uid') && $userUid !== '') {
    $cols[] = 'user_uid'; $vals[] = $userUid;
  }
  if (has_column($pdo, 'room_emoji_events', 'created_at')) {
    $cols[] = 'created_at'; $vals[] = date('Y-m-d H:i:s');
  }

  if (!in_array('user_id', $cols, true) && !in_array('user_uid', $cols, true)) {
    jfail('events_table_missing_columns', 500);
  }

  $ph = implode(',', array_fill(0, count($cols), '?'));
  $sql = 'INSERT INTO room_emoji_events ('.implode(',', $cols).') VALUES ('.$ph.')';
  $st = $pdo->prepare($sql);
  $st->execute($vals);

  jok(['id' => $pdo->lastInsertId()]);

} catch (Throwable $e) {
  // أظهر رسالة مفيدة أثناء التطوير؛ احذف msg في الإنتاج
  jfail('server_error', 500, ['msg'=>$e->getMessage()]);
}
