<?php
// voicechat/api/dm.php
require_once __DIR__ . '/config.php';

/* هوية المستخدم الحالي – مرن مع كل أشكال require_user() */
function current_user_id(): int {
  $u = require_user();                 // قد يرجع مصفوفة أو رقمًا
  if (is_array($u)) {
    foreach (['id','uid','user_id','userid'] as $k) {
      if (isset($u[$k]) && (int)$u[$k] > 0) {
        return (int)$u[$k];
      }
    }
    return 0;
  }
  return (int)$u;
}

$myId = current_user_id();
if ($myId <= 0) {
  json_out(['ok'=>false,'error'=>'bad_auth'], 401);
}

/* استخراج action من المسار أو من ?action= */
$path   = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$action = '';
if (preg_match('~(?:^|/)dm(?:\.php)?(?:/([^/]+))?~i', $path, $m)) {
  $action = strtolower($m[1] ?? '');
}
if (!$action) $action = strtolower($_GET['action'] ?? '');
$method = strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');

/* هل المستخدمان أصدقاء؟ (بدون افتراض ترتيب الأعمدة) */
function are_friends(int $a, int $b): bool {
  $pdo = db();
  $st  = $pdo->prepare('
    SELECT status FROM friends
    WHERE (uid1 = ? AND uid2 = ?) OR (uid1 = ? AND uid2 = ?)
    LIMIT 1
  ');
  $st->execute([$a,$b,$b,$a]);
  $row = $st->fetch();
  return $row && $row['status'] === 'accepted';
}

/* إيجاد أو إنشاء ثريد يجمع المستخدمين */
function find_or_create_thread(int $a, int $b): int {
  $pdo = db();

  // ابحث عن ثريد موجود يجمعهما
  $st = $pdo->prepare('
    SELECT t.id
    FROM dm_threads t
    JOIN dm_participants p1 ON p1.thread_id = t.id AND p1.user_id = ?
    JOIN dm_participants p2 ON p2.thread_id = t.id AND p2.user_id = ?
    LIMIT 1
  ');
  $st->execute([$a,$b]);
  if ($row = $st->fetch()) {
    return (int)$row['id'];
  }

  // أنشئ ثريدًا جديدًا
  $pdo->beginTransaction();
  try {
    $pdo->exec('INSERT INTO dm_threads (created_at, updated_at) VALUES (NOW(), NOW())');
    $threadId = (int)$pdo->lastInsertId();

    $ins = $pdo->prepare('INSERT INTO dm_participants (thread_id, user_id, created_at) VALUES (?, ?, NOW())');
    $ins->execute([$threadId, $a]);
    $ins->execute([$threadId, $b]);

    $pdo->commit();
    return $threadId;
  } catch (Throwable $e) {
    $pdo->rollBack();
    throw $e;
  }
}

/* التحقق أن المستخدم عضو في الثريد */
function is_participant(int $threadId, int $userId): bool {
  $pdo = db();
  $st  = $pdo->prepare('SELECT 1 FROM dm_participants WHERE thread_id = ? AND user_id = ? LIMIT 1');
  $st->execute([$threadId,$userId]);
  return (bool)$st->fetch();
}

/* ======================= الإجراءات ======================= */

/* POST /dm.php/open_or_create   body: { peer_uid } */
if ($action === 'open_or_create' && $method === 'POST') {
  $in = json_in();
  $peerUid = (int)($in['peer_uid'] ?? 0);
  if ($peerUid <= 0 || $peerUid === $myId) {
    json_out(['ok'=>false,'error'=>'bad_peer_uid'], 400);
  }

  if (!are_friends($myId, $peerUid)) {
    json_out(['ok'=>false,'error'=>'not_friends'], 403);
  }

  $threadId = find_or_create_thread($myId, $peerUid);
  json_out([
    'ok'        => true,
    'thread_id' => $threadId,
    'thread'    => ['id' => $threadId],        // توافقًا مع عميل Flutter
    'peer'      => user_summary($peerUid) ?: new stdClass(),
  ]);
}

/* GET /dm.php/messages?thread_id=..&after_id=..&limit=.. */
if ($action === 'messages' && $method === 'GET') {
  $threadId = (int)($_GET['thread_id'] ?? 0);
  $afterId  = (int)($_GET['after_id']  ?? 0);
  $limit    = (int)($_GET['limit']     ?? 50);
  if ($limit <= 0 || $limit > 100) $limit = 50;

  if ($threadId <= 0) json_out(['ok'=>false,'error'=>'bad_thread_id'], 400);
  if (!is_participant($threadId,$myId)) json_out(['ok'=>false,'error'=>'not_participant'], 403);

  $pdo = db();
  if ($afterId > 0) {
    $st = $pdo->prepare("
      SELECT m.*, u.username, u.avatar_url, u.userid
      FROM dm_messages m
      LEFT JOIN users u ON u.id = m.user_id
      WHERE m.thread_id = ? AND m.id > ?
      ORDER BY m.id ASC
      LIMIT {$limit}
    ");
    $st->execute([$threadId,$afterId]);
    $rows = $st->fetchAll();
  } else {
    $st = $pdo->prepare("
      SELECT m.*, u.username, u.avatar_url, u.userid
      FROM dm_messages m
      LEFT JOIN users u ON u.id = m.user_id
      WHERE m.thread_id = ?
      ORDER BY m.id DESC
      LIMIT {$limit}
    ");
    $st->execute([$threadId]);
    $rows = array_reverse($st->fetchAll()); // أرسل الأقدم أولاً
  }

  json_out(['ok'=>true,'items'=>$rows]);
}

/* POST /dm.php/send   body: { thread_id, text } */
if ($action === 'send' && $method === 'POST') {
  $in       = json_in();
  $threadId = (int)($in['thread_id'] ?? 0);
  $text     = trim((string)($in['text'] ?? ''));
  if ($threadId <= 0 || $text === '') {
    json_out(['ok'=>false,'error'=>'bad_params'], 400);
  }
  if (!is_participant($threadId,$myId)) json_out(['ok'=>false,'error'=>'not_participant'], 403);

  $pdo = db();
  $st  = $pdo->prepare('INSERT INTO dm_messages (thread_id, user_id, text, created_at) VALUES (?, ?, ?, NOW())');
  $st->execute([$threadId,$myId,$text]);
  $msgId = (int)$pdo->lastInsertId();

  $pdo->prepare('UPDATE dm_threads SET updated_at = NOW() WHERE id = ?')->execute([$threadId]);

  $summary = user_summary($myId) ?: [];
  json_out([
    'ok'=>true,
    'message'=>[
      'id'         => $msgId,
      'thread_id'  => $threadId,
      'user_id'    => $myId,
      'text'       => $text,
      'created_at' => date('c'),
      'username'   => $summary['username']   ?? '',
      'avatar_url' => $summary['avatar_url'] ?? '',
      'userid'     => $summary['userid']     ?? '',
    ],
  ]);
}

/* أي مسار آخر */
json_out(['ok'=>false,'error'=>'not_found'], 404);
