<?php
// voicechat/api/config.php

// =================== DB CONFIG ===================
$DB_HOST = "localhost";
$DB_NAME = "u564352071_vociechat";
$DB_USER = "u564352071_vociechat";
$DB_PASS = "#5^n]Z|sV5c";

// =================== JWT SECRET ===================
// بدّلها لسر قوي وثابت (لا تُنشره علنًا)
$JWT_SECRET = "change_me_super_secret_32_chars_min";

// =================== AGORA (server-side) ===================
// لو الـ App Certificate غير مفعّل يمكنك تركه فارغًا
$AGORA_APP_ID   = "889c191238b54e268ba9367292bf9a69";
$AGORA_APP_CERT = "";

// =================== MOMENT FILES PATHS (اختياري) ===================
$FILES_MOMENT_BASE_DIR = dirname(__DIR__) . '/files/moment';
$FILES_MOMENT_BASE_URL = 'https://battle-party.com/voicechat/files/moment';

// ===========================================================
// DB helper
function db(): PDO {
  global $DB_HOST,$DB_NAME,$DB_USER,$DB_PASS;
  static $pdo = null;
  if ($pdo === null) {
    $pdo = new PDO(
      "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
      $DB_USER,
      $DB_PASS,
      [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      ]
    );
  }
  return $pdo;
}

// ===========================================================
// CORS + JSON helpers
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Authorization, Content-Type');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  http_response_code(204);
  exit;
}

function json_out($data, int $code = 200){
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Authorization, Content-Type');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  echo json_encode($data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

// بعض السكربتات القديمة تستخدم respond()
if (!function_exists('respond')) {
  function respond($arr, int $code = 200) { json_out($arr, $code); }
}

function json_in(): array {
  $raw = file_get_contents('php://input');
  $j = json_decode($raw, true);
  return is_array($j) ? $j : [];
}

// ===========================================================
// Base64URL helpers
function b64url($s){ return rtrim(strtr(base64_encode($s), '+/','-_'), '='); }
function b64url_decode($s){ return base64_decode(strtr($s, '-_','+/')); }

// ===========================================================
// JWT helpers (HS256) — بدون composer
function jwt_encode(array $payload): string{
  global $JWT_SECRET;
  $header = ['alg'=>'HS256','typ'=>'JWT'];
  $h = b64url(json_encode($header));
  $p = b64url(json_encode($payload));
  $sig = b64url(hash_hmac('sha256', "$h.$p", $JWT_SECRET, true));
  return "$h.$p.$sig";
}

function jwt_decode_or_null(string $jwt){
  global $JWT_SECRET;
  $parts = explode('.', $jwt);
  if (count($parts) !== 3) return null;
  [$h, $p, $s] = $parts;
  $calc = b64url(hash_hmac('sha256', "$h.$p", $JWT_SECRET, true));
  if (!hash_equals($calc, $s)) return null;
  $payload = json_decode(b64url_decode($p), true);
  if (!is_array($payload)) return null;
  return $payload;
}

// نسخة ترمي استثناء (لبعض السكربتات)
function jwt_decode(string $jwt): array {
  $payload = jwt_decode_or_null($jwt);
  if (!$payload) throw new Exception('bad_token_signature');
  return $payload;
}

// ===========================================================
// Authorization helpers (موحّدة للغرف واللحظات)

// اجمع Authorization من كل المصادر الشائعة + دعم token= عبر GET/POST
function get_bearer_token(): ?string {
  // 1) متغيرات السيرفر
  foreach (['HTTP_AUTHORIZATION','Authorization','REDIRECT_HTTP_AUTHORIZATION','HTTP_AUTHENTICATION'] as $k) {
    if (!empty($_SERVER[$k]) && preg_match('/Bearer\s+(.+)/i', $_SERVER[$k], $m)) {
      return trim($m[1]);
    }
  }
  // 2) getallheaders()/apache_request_headers
  if (function_exists('getallheaders')) {
    foreach (getallheaders() as $k => $v) {
      if (strcasecmp($k, 'Authorization') === 0 && preg_match('/Bearer\s+(.+)/i', $v, $m)) {
        return trim($m[1]);
      }
    }
  } elseif (function_exists('apache_request_headers')) {
    $h = apache_request_headers();
    foreach ($h as $k => $v) {
      if (strcasecmp($k, 'Authorization') === 0 && preg_match('/Bearer\s+(.+)/i', $v, $m)) {
        return trim($m[1]);
      }
    }
  }
  // 3) احتياطي لبيئات لا تمرّر الهيدر في POST/multipart
  if (!empty($_POST['token'])) return trim($_POST['token']);
  if (!empty($_GET['token']))  return trim($_GET['token']);
  return null;
}

// يرجع الـ Payload أو يرد 401 (لا تشترط وجود uid فقط)
function require_auth(){
  $jwt = get_bearer_token();
  if (!$jwt) json_out(['ok'=>false,'error'=>'missing_token'], 401);
  try {
    $payload = jwt_decode($jwt);
  } catch (Throwable $e) {
    json_out(['ok'=>false,'error'=>'invalid_token'], 401);
  }
  if (!$payload || !is_array($payload)) json_out(['ok'=>false,'error'=>'invalid_token'], 401);
  return $payload;
}

// ===== تحويل uid النصّي إلى id الرقمي من قاعدة البيانات =====
function _uid_text_to_id(string $uidText): int {
  $uidText = trim($uidText);
  if ($uidText === '') return 0;
  // إن كان uid رقمياً أصلاً
  if (ctype_digit($uidText)) return (int)$uidText;
  try {
    $st = db()->prepare('SELECT id FROM users WHERE uid=? LIMIT 1');
    $st->execute([$uidText]);
    $id = (int)$st->fetchColumn();
    return $id > 0 ? $id : 0;
  } catch (Throwable $e) {
    return 0;
  }
}

// UID فقط (0 إذا لم يوجد) — يُعيد users.id دائمًا
function bearer_user_id(): int {
  $t = get_bearer_token();
  if (!$t) return 0;
  $p = jwt_decode_or_null($t);
  if (!$p) return 0;
  if (!empty($p['id']))  return (int)$p['id'];                 // مفضّل
  if (!empty($p['uid'])) return _uid_text_to_id((string)$p['uid']);
  return 0;
}

// يوقف التنفيذ بـ 401 إن لم يكن مسجلاً — يُعيد users.id دائمًا
function require_user(): int {
  $payload = require_auth(); // سيُخرج 401 إن فشل
  if (!empty($payload['id']))  return (int)$payload['id'];
  if (!empty($payload['uid'])) {
    $id = _uid_text_to_id((string)$payload['uid']);
    if ($id > 0) return $id;
    json_out(['ok'=>false,'error'=>'auth_bad_uid'], 401);
  }
  json_out(['ok'=>false,'error'=>'invalid_token'], 401);
}

// مختصر معلومات المستخدم
function user_summary(int $uid): array {
  $pdo = db();
  $st = $pdo->prepare('
    SELECT
      id,
      COALESCE(userid, "")    AS userid,
      COALESCE(username, "")  AS username,
      COALESCE(avatar_url,"") AS avatar_url
    FROM users
    WHERE id = ?
    LIMIT 1
  ');
  $st->execute([$uid]);
  return $st->fetch() ?: ['id'=>$uid,'username'=>'Unknown','avatar_url'=>''];
}
