<?php
// api/coins_get.php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

// هيدرز JSON + CORS (اختياري لكنه مفيد للتطبيقات المحمولة)
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type, Accept');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function ok($d=[], $code=200){ http_response_code($code); echo json_encode(['ok'=>true]+$d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bad($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$pdo = function_exists('db') ? db() : ($pdo ?? null);
if (!$pdo) bad('DB connection unavailable', 500);

// قد تعيد مصفوفة فيها ['uid'=>..,'id'=>..] أو قيمة مفردة
$user = auth_required();

$uid = null; $id = null;
if (is_array($user)) {
  $uid = $user['uid'] ?? null;
  $id  = $user['id']  ?? ($user['userid'] ?? null);
} else {
  // إن كانت قيمة مفردة: إن كانت أرقامًا فقط اعتبرها id، وإلا uid
  if (is_string($user) && ctype_digit($user)) $id = (int)$user;
  elseif (is_numeric($user)) $id = (int)$user;
  else $uid = (string)$user;
}

if ($uid) {
  $st = $pdo->prepare('SELECT coins FROM users WHERE uid = ? LIMIT 1');
  $st->execute([$uid]);
} else {
  $st = $pdo->prepare('SELECT coins FROM users WHERE id = ? LIMIT 1');
  $st->execute([(int)$id]);
}

$coins = (int)($st->fetchColumn() ?: 0);
ok(['coins' => $coins]);
