<?php
// api/billing/google_verify.php
require_once __DIR__.'/../bootstrap.php';
require_login(); // استخرج $userId

use Google\Client as GoogleClient;
use Google\Service\AndroidPublisher;

header('Content-Type: application/json; charset=utf-8');

$sku = trim($_POST['sku'] ?? '');
$token = trim($_POST['purchase_token'] ?? '');
if ($sku === '' || $token === '') json_fail('bad_params');

$pdo = db();
$pdo->beginTransaction();

try {
  // تحقق عدم استخدام التوكن مسبقًا
  $chk = $pdo->prepare("SELECT id FROM billing_google_receipts WHERE purchase_token=?");
  $chk->execute([$token]);
  if ($chk->fetchColumn()) {
    $pdo->rollBack();
    json_fail('already_used', 409);
  }

  // جلب coins المقابلة للـsku
  $st = $pdo->prepare("SELECT coins FROM billing_google_products WHERE sku=? AND enabled=1");
  $st->execute([$sku]);
  $coins = (int)($st->fetchColumn() ?: 0);
  if ($coins <= 0) {
    $pdo->rollBack();
    json_fail('sku_disabled', 400);
  }

  // إعداد Google API (خدمة حساب Service Account)
  $client = new GoogleClient();
  $client->setAuthConfig(__DIR__.'/service_account.json'); // ارفع ملف الخدمة هنا
  $client->addScope(AndroidPublisher::ANDROIDPUBLISHER);
  $svc = new AndroidPublisher($client);

  $packageName = 'com.voicechat.wesal'; // عدّل إلى حزمة تطبيقك
  // تحقق من المنتج (one-time product)
  $resp = $svc->purchases_products->get($packageName, $sku, $token);

  // purchaseState: 0=Purchased, 1=Canceled, 2=Pending
  if ((int)$resp->purchaseState !== 0) {
    $pdo->rollBack();
    json_fail('not_purchased', 400);
  }

  // اختياري: orderId
  $orderId = property_exists($resp, 'orderId') ? (string)$resp->orderId : null;

  // أثبت السجل ثم أضف الرصيد
  $ins = $pdo->prepare("INSERT INTO billing_google_receipts (user_id, sku, purchase_token, order_id, coins, status)
                        VALUES (?, ?, ?, ?, ?, 'credited')");
  $ins->execute([$userId, $sku, $token, $orderId, $coins]);

  // زيادة الرصيد
  $upd = $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id = ?");
  $upd->execute([$coins, $userId]);

  // يُستحسن تسجّل معاملة في جدول الحركات إن لديك
  // INSERT INTO coins_transactions (...) VALUES (...)

  // ارجع الرصيد الجديد
  $get = $pdo->prepare("SELECT coins FROM users WHERE id=?");
  $get->execute([$userId]);
  $newBalance = (int)$get->fetchColumn();

  $pdo->commit();
  echo json_encode(['ok'=>1, 'coins_added'=>$coins, 'new_balance'=>$newBalance], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  json_fail('server_error', 500);
}
