<?php
// backend/api/auth_register.php
require __DIR__ . '/config.php';

$input = json_decode(file_get_contents('php://input'), true);
$email = trim($input['email'] ?? '');
$username = trim($input['username'] ?? '');
$password = $input['password'] ?? '';

if (!$email || !$password || !$username) json_out(['error'=>'missing_fields'],422);

$uid = sprintf('%s', com_create_guid() ?: bin2hex(random_bytes(16)));
if (strpos($uid, '{') !== false) { $uid = trim($uid, '{}'); }
if (strlen($uid) > 36) $uid = substr($uid,0,36);

try{
  $stmt = db()->prepare("INSERT INTO users (uid,email,username,password_hash) VALUES (?,?,?,?)");
  $stmt->execute([$uid, $email, $username, password_hash($password, PASSWORD_BCRYPT)]);
} catch(Exception $e){
  json_out(['error'=>'email_exists'],409);
}

$token = jwt_encode(['uid'=>$uid,'username'=>$username,'iat'=>time()]);

json_out(['ok'=>true,'uid'=>$uid,'username'=>$username,'token'=>$token]);
