<?php
// voicechat/api/app_update.php
require_once __DIR__ . '/config.php'; // يحتوي db() و json_out()

header('Content-Type: application/json; charset=utf-8');

try {
  $pdo = db();

  // اقرأ مفاتيح الإعداد دفعة واحدة
  $keys = [
    'android_latest_code', 'android_latest_name',
    'android_min_code',    'android_update_url',
    'android_notes_ar'
  ];
  $in  = implode(',', array_fill(0, count($keys), '?'));
  $st  = $pdo->prepare("SELECT `key`,`value` FROM app_settings WHERE `key` IN ($in)");
  $st->execute($keys);
  $map = [];
  foreach ($st as $r) { $map[$r['key']] = $r['value']; }

  // تفريغ آمن مع قيم افتراضية
  $latestCode = (int)($map['android_latest_code'] ?? 1);
  $latestName = (string)($map['android_latest_name'] ?? '1.0.0');
  $minCode    = (int)($map['android_min_code'] ?? 1);
  $url        = (string)($map['android_update_url'] ?? '');
  $notes      = (string)($map['android_notes_ar'] ?? '');

  $out = [
    'ok' => true,
    'platform' => 'android',
    'latest_version_code' => $latestCode,
    'latest_version_name' => $latestName,
    'min_supported_code'  => $minCode,
    'update_url'          => $url,
    'notes'               => $notes,
  ];

  echo json_encode($out, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'server_error'], JSON_UNESCAPED_UNICODE);
}
