<?php
// backend/api/agora_token.php
require __DIR__ . '/config.php';

// استخدم require_auth إن وُجد، وإلا اعتبره "guest"
$auth = function_exists('require_auth') ? require_auth() : ['uid' => 'guest'];
$user_uid = $auth['uid'] ?? 'guest';

// اقرأ JSON أو POST
$raw   = file_get_contents('php://input');
$input = json_decode($raw, true);
if (!is_array($input)) { $input = $_POST; }

$room_uid = isset($input['room_uid']) ? trim($input['room_uid']) : '';
if ($room_uid === '') {
  json_out(['ok'=>false,'error'=>'missing_room_uid'], 422);
}

// تأكد من App ID
if (empty($AGORA_APP_ID)) {
  json_out(['ok'=>false,'error'=>'agora_app_id_missing'], 500);
}

// uid رقمي ثابت لنفس المستخدم
$uidNumeric  = hexdec(substr(md5($user_uid), 0, 8)) % 1000000000;
// اسم القناة (عدّله لو لوجيكك مختلف)
$channelName = $room_uid;
// مدة صلاحية التوكن
$ttl = 3600;
$token = "";

// لو الشهادة مفعلة نولّد توكن
if (!empty($AGORA_APP_CERT)) {
  $builder1 = __DIR__ . '/lib/agora/AccessToken2.php';
  $builder2 = __DIR__ . '/lib/agora/RtcTokenBuilder2.php';
  if (!file_exists($builder1) || !file_exists($builder2)) {
    json_out([
      'ok'=>false,
      'error'=>'token_builder_missing_files',
      'hint'=>'Put AccessToken2.php and RtcTokenBuilder2.php under backend/api/lib/agora/'
    ], 500);
  }

  require_once $builder1;
  require_once $builder2;

  try {
    $rolePublisher = 1; // PUBLISHER
    // بعض الإصدارات تقبل مدة، وأخرى timestamp:
    $tok = \RtcTokenBuilder2::buildTokenWithUid(
      $AGORA_APP_ID, $AGORA_APP_CERT, $channelName, (int)$uidNumeric, $rolePublisher, $ttl
    );
    if (!is_string($tok) || strlen($tok) < 10) {
      $tok = \RtcTokenBuilder2::buildTokenWithUid(
        $AGORA_APP_ID, $AGORA_APP_CERT, $channelName, (int)$uidNumeric, $rolePublisher, time() + $ttl
      );
    }
    if (!is_string($tok) || strlen($tok) < 10) {
      json_out(['ok'=>false,'error'=>'token_build_empty'], 500);
    }
    $token = $tok;
  } catch (Throwable $e) {
    json_out(['ok'=>false,'error'=>'token_build_failed','detail'=>$e->getMessage()], 500);
  }
}

// نفس بنية الرد التي يعتمدها العميل لديك
json_out([
  'ok'    => true,
  'agora' => [
    'appId'       => $AGORA_APP_ID,
    'channelName' => $channelName,
    'token'       => $token,     // غير فارغ إذا كانت الشهادة مفعلة وسليم
    'uidNumeric'  => $uidNumeric,
    'expiresIn'   => $ttl
  ]
]);
