<?php
// api/agents_list.php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type, Accept');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function ok($d=[], $c=200){ http_response_code($c); echo json_encode(['ok'=>true]+$d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bad($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$pdo = db();

// يمكن لاحقاً اشتراط auth_required() إذا أردت
$sql = "
  SELECT
    a.id,
    a.username,
    a.display_name,
    a.status,
    a.main_balance,
    a.created_at,
    a.app_user_uid,
    u.username AS app_username,
    u.avatar_url AS app_avatar_url
  FROM agents a
  LEFT JOIN users u ON u.uid = a.app_user_uid
  WHERE a.status = 'active'
  ORDER BY a.display_name ASC, a.id ASC
";
$rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) ?: [];

$agents = [];
foreach ($rows as $r) {
  $agents[] = [
    'id'           => (int)$r['id'],
    'display_name' => $r['display_name'] ?: $r['username'],
    'status'       => $r['status'],
    'main_balance' => (int)$r['main_balance'],
    'user' => [
      'uid'        => $r['app_user_uid'],
      'username'   => $r['app_username'],
      'avatar_url' => $r['app_avatar_url'],
    ],
  ];
}

ok(['agents' => $agents]);
