<?php
// /public_html/voicechat/agents/web/dashboard.php
declare(strict_types=1);
require_once __DIR__ . '/_web_common.php';

/* ---------- AJAX: البحث عن المستخدم بـ userid (مباشر من DB) ---------- */
if (($_GET['ajax'] ?? '') === 'lookup_user') {
  header('Content-Type: application/json; charset=utf-8');
  if (!agent_get_token()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'unauthorized']); exit; }

  $userid = trim((string)($_GET['userid'] ?? ''));
  if ($userid === '') { echo json_encode(['ok'=>false,'error'=>'empty']); exit; }

  try {
    $pdo = db();
    $st = $pdo->prepare("
      SELECT id, uid, userid, username, avatar_url
      FROM users
      WHERE CAST(userid AS CHAR) = ? OR userid = ?
      LIMIT 1
    ");
    $st->execute([$userid, $userid]);
    $u = $st->fetch(PDO::FETCH_ASSOC);

    if ($u) {
      echo json_encode([
        'ok'   => true,
        'user' => [
          'id'       => (int)$u['id'],
          'uid'      => (string)$u['uid'],
          'userid'   => (string)$u['userid'],
          'username' => (string)($u['username'] ?? ''),
          'avatar'   => (string)($u['avatar_url'] ?? ''),
        ]
      ], JSON_UNESCAPED_UNICODE);
    } else {
      echo json_encode(['ok'=>false,'error'=>'not_found']);
    }
  } catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'server_error']);
  }
  exit;
}

/* ---------- صفحة اللوحة ---------- */
$auth  = require_agent_or_redirect();
$token = $auth['token'];
$agent = $auth['agent'];

function agent_usd_display(array $agent): string {
  if (isset($agent['usd_display'])) return number_format((float)$agent['usd_display'], 2, '.', '');
  if (isset($agent['usd_balance_cents'])) return number_format(((int)$agent['usd_balance_cents'])/100, 2, '.', '');
  if (isset($agent['usd_balance'])) return number_format((float)$agent['usd_balance'], 2, '.', '');
  return '0.00';
}

$msg = null; $err = null; $result = null;

/* ---------- تنفيذ الشحن مباشرة في قاعدة البيانات ---------- */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    $user_uid = trim((string)($_POST['user_uid'] ?? ''));
    $coins    = (int)($_POST['coins'] ?? 0);

    if ($user_uid === '' || $coins <= 0) {
      $err='من فضلك أدخل UserID صحيح والمبلغ.';
    } else {
      $pdo = db();
      try {
        $pdo->beginTransaction();

        // اجلب صف الوكيل واقفله
        $stA = $pdo->prepare("SELECT id, main_balance FROM agents WHERE id=? FOR UPDATE");
        $stA->execute([(int)$agent['id']]);
        $a = $stA->fetch(PDO::FETCH_ASSOC);
        if (!$a) throw new RuntimeException('agent_not_found');

        // اجلب المستخدم واقفله
        $stU = $pdo->prepare("SELECT id, uid, coins, username, avatar_url, userid FROM users WHERE uid=? FOR UPDATE");
        $stU->execute([$user_uid]);
        $u = $stU->fetch(PDO::FETCH_ASSOC);
        if (!$u) {
          // سجل عملية فاشلة في agent_charges ثم ارمي خطأ منطقي
          $insFail = $pdo->prepare("INSERT INTO agent_charges (agent_id, user_uid, coins, status, error_code, created_at) VALUES (?,?,?,?,?,NOW())");
          $insFail->execute([(int)$agent['id'], $user_uid, $coins, 'error', 'user_not_found']);
          throw new RuntimeException('user_not_found');
        }

        $bal = (int)$a['main_balance'];
        if ($bal < $coins) {
          $insFail = $pdo->prepare("INSERT INTO agent_charges (agent_id, user_uid, coins, status, error_code, created_at) VALUES (?,?,?,?,?,NOW())");
          $insFail->execute([(int)$agent['id'], (string)$u['uid'], $coins, 'error', 'insufficient_balance']);
          throw new RuntimeException('insufficient_balance');
        }

        // خصم من الوكيل وإضافة إلى المستخدم
        $new_bal = $bal - $coins;

        $uUser = $pdo->prepare("UPDATE users SET coins = coins + ? WHERE id=?");
        $uUser->execute([$coins, (int)$u['id']]);

        $uAgent = $pdo->prepare("UPDATE agents SET main_balance = ? WHERE id=?");
        $uAgent->execute([$new_bal, (int)$agent['id']]);

        // قيد في دفتر الوكيل
        $has_currency = (function(PDO $pdo): bool {
          try { $s=$pdo->query("SHOW COLUMNS FROM agent_ledger LIKE 'currency'"); return (bool)$s->fetchColumn(); }
          catch(Throwable $e){ return false; }
        })($pdo);

        if ($has_currency) {
          $insL = $pdo->prepare("INSERT INTO agent_ledger (agent_id, direction, reason, amount, balance_after, ref_user_uid, currency, created_at)
                                 VALUES (?,?,?,?,?,?,?,NOW())");
          $insL->execute([(int)$agent['id'], 'out', 'charge_user', $coins, $new_bal, (string)$u['uid'], 'coins']);
          $ledger_id = (int)$pdo->lastInsertId();
        } else {
          $insL = $pdo->prepare("INSERT INTO agent_ledger (agent_id, direction, reason, amount, balance_after, ref_user_uid, created_at)
                                 VALUES (?,?,?,?,?,?,NOW())");
          $insL->execute([(int)$agent['id'], 'out', 'charge_user', $coins, $new_bal, (string)$u['uid']]);
          $ledger_id = (int)$pdo->lastInsertId();
        }

        // سجل العملية في agent_charges
        $insC = $pdo->prepare("INSERT INTO agent_charges (agent_id, user_uid, coins, status, error_code, ledger_id, created_at)
                               VALUES (?,?,?,?,?,?,NOW())");
        $insC->execute([(int)$agent['id'], (string)$u['uid'], $coins, 'success', null, $ledger_id]);

        $pdo->commit();

        $msg    = 'تم شحن ' . (int)$coins . ' كوين للمستخدم.';
        $result = ['agent_balance_after' => $new_bal];

        // أعِد تحميل بيانات الوكيل من القاعدة
        $aReload = agent_reload($token);
        if ($aReload) $agent = $aReload;

      } catch (Throwable $e) {
        if ($pdo->inTransaction()) { try { $pdo->rollBack(); } catch(Throwable $e2){} }
        $code = $e->getMessage();
        if ($code === 'user_not_found')           $err = 'المستخدم غير موجود.';
        elseif ($code === 'insufficient_balance') $err = 'رصيد الوكيل غير كافٍ.';
        else                                      $err = 'تعذّر الشحن.';
      }
    }
  }
}

/* ---------- إحصائيات الشحن: اليوم / الأسبوع السبت-الجمعة / الإجمالي ---------- */
$stats_today = 0;
$stats_week  = 0;
$stats_all   = 0;

try {
  $pdoS = db();

  // اليوم (من 00:00 إلى +1 يوم)
  $todayStart = (new DateTime('today'));
  $todayEnd   = (clone $todayStart)->modify('+1 day');

  $stT = $pdoS->prepare("
    SELECT COALESCE(SUM(coins),0) FROM agent_charges
    WHERE agent_id=? AND status='success' AND created_at >= ? AND created_at < ?
  ");
  $stT->execute([(int)$agent['id'], $todayStart->format('Y-m-d H:i:s'), $todayEnd->format('Y-m-d H:i:s')]);
  $stats_today = (int)$stT->fetchColumn();

  // بداية الأسبوع (السبت 00:00) وحتى الجمعة 23:59:59 (exclusive +7 أيام)
  // w: 0=الأحد .. 6=السبت
  $w = (int)$todayStart->format('w');
  $diffToSat = ($w - 6 + 7) % 7; // كم يوم نرجع لنصل للسبت
  $weekStart = (clone $todayStart)->modify("-{$diffToSat} days"); // سبت
  $weekEnd   = (clone $weekStart)->modify('+7 days');             // السبت القادم

  $stW = $pdoS->prepare("
    SELECT COALESCE(SUM(coins),0) FROM agent_charges
    WHERE agent_id=? AND status='success' AND created_at >= ? AND created_at < ?
  ");
  $stW->execute([(int)$agent['id'], $weekStart->format('Y-m-d H:i:s'), $weekEnd->format('Y-m-d H:i:s')]);
  $stats_week = (int)$stW->fetchColumn();

  // الإجمالي (كل الفترات)
  $stA = $pdoS->prepare("
    SELECT COALESCE(SUM(coins),0) FROM agent_charges
    WHERE agent_id=? AND status='success'
  ");
  $stA->execute([(int)$agent['id']]);
  $stats_all = (int)$stA->fetchColumn();

} catch (Throwable $e) {
  // لا شيء — نعرض 0 إذا حدث خطأ
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1">
  <title>لوحة الوكيل</title>
  <style>
    :root{
      --bg:#0b1220;--panel:#0f172a;--text:#e5e7eb;--sub:#94a3b8;
      --border:#243047;--primary:#3b82f6;--danger:#ef4444;--ok:#22c55e
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto}
    a{color:#93c5fd;text-decoration:none}
    header{
      position:sticky;top:0;z-index:10;
      display:flex;gap:12px;align-items:center;justify-content:space-between;
      padding:12px 16px;border-bottom:1px solid var(--border);background:#0c1426;
      flex-wrap:wrap;
    }
    .brand{font-weight:700;font-size:18px;display:flex;gap:8px;align-items:center;flex-wrap:wrap}
    .chip{
      display:inline-flex;align-items:center;gap:8px;
      border:1px solid #2b3753;background:linear-gradient(180deg,#0f1a33,#0d1529);
      padding:8px 12px;border-radius:999px;font-weight:700;white-space:nowrap
    }
    .chip.usd{border-color:#2e7d32}
    .chip .coin{font-size:18px;line-height:1}
    .chip .num{font-variant-numeric:tabular-nums}
    .btn{
      display:inline-block;padding:8px 12px;border-radius:10px;border:1px solid var(--border);
      background:#1a2336;color:var(--text);cursor:pointer
    }
    .btn.pri{background:var(--primary);color:#fff}
    .btn.dan{background:var(--danger);color:#fff}
    .btn[disabled]{opacity:.5;pointer-events:none}
    .wrap{max-width:960px;margin:0 auto;padding:16px}
    .cards{display:grid;gap:16px;grid-template-columns:1fr 1fr}
    @media (max-width: 860px){ .cards{grid-template-columns:1fr} }
    .card{background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:16px}
    h2{margin:0 0 12px}
    .form{display:grid;gap:12px}
    .input label{display:block;font-size:13px;margin-bottom:6px;color:var(--sub)}
    .input input{
      width:100%;padding:12px;border-radius:12px;border:1px solid var(--border);
      background:#0c1426;color:var(--text);font-size:15px
    }
    .row{display:flex;gap:8px;flex-wrap:wrap}
    .row .btn{min-width:120px}
    .alert{
      border:1px solid var(--danger);padding:10px 12px;border-radius:12px;background:rgba(239,68,68,.08);margin-bottom:8px
    }
    .alert.ok{border-color:var(--ok);background:rgba(34,197,94,.08)}
    .mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace}
    .muted{color:var(--sub)}
    .found{display:flex;align-items:center;gap:10px;margin-top:6px}
    .pill{display:inline-block;border:1px solid var(--border);border-radius:999px;padding:2px 8px;font-size:12px}
    .pill.ok{border-color:var(--ok)}
    .pill.bad{border-color:#ef4444}
    .avatar{width:36px;height:36px;border-radius:999px;object-fit:cover;border:1px solid var(--border);background:#0c1426}
    /* بطاقات الإحصائيات */
    .stats{display:grid;gap:12px;grid-template-columns:repeat(3,1fr);margin-top:16px}
    @media (max-width:720px){ .stats{grid-template-columns:1fr} }
    .stat{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
    .stat h4{margin:0 0 6px;font-size:14px;color:var(--sub)}
    .stat .val{font-size:22px;font-weight:800}
    @media (max-width:520px){
      .brand{font-size:16px}
      .btn, .input input{font-size:16px}
      .row{flex-direction:column}
      .row .btn{width:100%}
    }
  </style>
</head>
<body>
<header>
  <div class="brand">
    <span>لوحة وكيل:</span>
    <b><?= e($agent['display_name'] ?? $agent['username'] ?? '') ?></b>
  </div>

  <!-- شارات الرصيد العلوية -->
  <div class="row" style="align-items:center">
    <div class="chip" title="رصيد الكوين">
      <span class="coin">🪙</span>
      <span class="num" id="balanceTopCoins"><?= (int)($agent['main_balance'] ?? 0) ?></span>
      <span class="muted" style="font-weight:600">كوين</span>
    </div>
    <div class="chip usd" title="رصيد الدولار">
      <span class="coin">💵</span>
      <span class="num" id="balanceTopUsd"><?= e(agent_usd_display($agent)) ?></span>
      <span class="muted" style="font-weight:600">$</span>
    </div>
  </div>

  <div class="row">
    <a class="btn" href="charges.php">سجل الشحن</a>
    <a class="btn" href="convert.php">تحويل $ ➜ كوين</a>
    <a class="btn" href="javascript:location.reload()">تحديث</a>
    <a class="btn dan" href="logout.php">خروج</a>
  </div>
</header>

<div class="wrap">
  <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
  <?php if ($msg): ?><div class="alert ok"><?= e($msg) ?></div><?php endif; ?>

  <div class="cards">
    <div class="card">
      <h2>بيانات الوكيل</h2>
      <div>المعرف: <span class="mono"><?= e((string)($agent['id'] ?? '')) ?></span></div>
      <div>اسم المستخدم: <span class="mono"><?= e((string)($agent['username'] ?? '')) ?></span></div>
      <div>الحالة: <b><?= e((string)($agent['status'] ?? '')) ?></b></div>
      <div>الرصيد الحالي: <b class="mono" id="balanceCardCoins"><?= (int)($agent['main_balance'] ?? 0) ?></b> كوين</div>
      <div>الدولار: <b class="mono" id="balanceCardUsd"><?= e(agent_usd_display($agent)) ?></b> $</div>
      <?php if (!empty($agent['last_login_at'])): ?>
        <div class="muted" style="margin-top:6px">آخر دخول: <?= e((string)$agent['last_login_at']) ?></div>
      <?php endif; ?>
    </div>

    <div class="card">
      <h2>شحن كوين لمستخدم</h2>
      <form method="post" class="form" id="chargeForm" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="user_uid" id="user_uid">

        <div class="input">
          <label>UserID المستخدم</label>
          <input name="userid" id="userid" required placeholder="اكتب UserID هنا">
          <div id="lookupBox" class="found muted" style="display:none">
            <img id="uAvatar" class="avatar" src="" alt="">
            <div>
              <div>الاسم: <b id="uName"></b></div>
              <div class="mono" style="font-size:12px">UID: <span id="uUid"></span></div>
            </div>
            <span id="uStatus" class="pill">—</span>
          </div>
        </div>

        <div class="input">
          <label>المبلغ (كوين)</label>
          <input name="coins" id="coins" type="number" min="1" step="1" required>
        </div>

        <div class="row">
          <button class="btn pri" id="submitBtn" type="submit" disabled>تنفيذ الشحن</button>
        </div>
      </form>

      <?php if ($result): ?>
        <div class="muted" style="margin-top:8px">
          تم الشحن — الرصيد بعد العملية: <b class="mono"><?= (int)($result['agent_balance_after'] ?? 0) ?></b>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- ====== إحصائيات الشحن ====== -->
  <div class="stats">
    <div class="stat">
      <h4>قيمة الشحن اليومي</h4>
      <div class="val mono"><?= number_format($stats_today) ?> كوين</div>
    </div>
    <div class="stat">
      <h4>قيمة الشحن الأسبوعي</h4>
      <div class="val mono"><?= number_format($stats_week) ?> كوين</div>
    </div>
    <div class="stat">
      <h4>إجمالي الشحن</h4>
      <div class="val mono"><?= number_format($stats_all) ?> كوين</div>
    </div>
  </div>
</div>

<script>
(function(){
  // بحث المستخدم بالـ userid
  const userid   = document.getElementById('userid');
  const box      = document.getElementById('lookupBox');
  const nameEl   = document.getElementById('uName');
  const uidEl    = document.getElementById('uUid');
  const avatarEl = document.getElementById('uAvatar');
  const statusEl = document.getElementById('uStatus');
  const uidInput = document.getElementById('user_uid');
  const submit   = document.getElementById('submitBtn');

  let timer = null, last = '';

  function setState(found, data){
    box.style.display = 'flex';
    if (found) {
      nameEl.textContent   = data.username || '(بدون اسم)';
      uidEl.textContent    = data.uid || '';
      avatarEl.src         = data.avatar || '';
      statusEl.textContent = 'صحيح';
      statusEl.className   = 'pill ok';
      uidInput.value       = data.uid || '';
      submit.disabled      = false;
    } else {
      nameEl.textContent   = '';
      uidEl.textContent    = '';
      avatarEl.src         = '';
      statusEl.textContent = 'غير موجود';
      statusEl.className   = 'pill bad';
      uidInput.value       = '';
      submit.disabled      = true;
    }
  }

  async function lookup(v){
    if (!v) { box.style.display='none'; uidInput.value=''; submit.disabled=true; return; }
    try{
      const res = await fetch('dashboard.php?ajax=lookup_user&userid=' + encodeURIComponent(v), {cache:'no-store'});
      const j   = await res.json();
      if (j && j.ok && j.user) setState(true, j.user);
      else setState(false, null);
    }catch(e){
      setState(false, null);
    }
  }

  userid.addEventListener('input', function(){
    const v = userid.value.trim();
    if (v === last) return;
    last = v;
    if (timer) clearTimeout(timer);
    timer = setTimeout(()=>lookup(v), 350);
  });

  // مزامنة شارات الرصيد من بطاقة البيانات
  const bc = document.getElementById('balanceCardCoins');
  const bu = document.getElementById('balanceCardUsd');
  const tc = document.getElementById('balanceTopCoins');
  const tu = document.getElementById('balanceTopUsd');
  if (bc && tc) tc.textContent = bc.textContent;
  if (bu && tu) tu.textContent = bu.textContent;
})();
</script>
</body>
</html>
