<?php
// /public_html/voicechat/agents/web/charges.php
declare(strict_types=1);
require_once __DIR__ . '/_web_common.php';

$auth      = require_agent_or_redirect();
$agent     = $auth['agent'];
$agent_id  = (int)($agent['id'] ?? 0);

if (!function_exists('e2')) {
  function e2(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

$pdo     = db();
$page    = max(1, (int)($_GET['page'] ?? 1));
$perPage = min(100, max(1, (int)($_GET['per_page'] ?? 20)));
$offset  = ($page - 1) * $perPage;
$q       = trim((string)($_GET['q'] ?? ''));

/* --------- Query: join users to show username, userid, avatar --------- */
$where   = "c.agent_id = ?";
$params  = [$agent_id];

if ($q !== '') {
  // بحث بالـ userid (كنص) أو بالاسم
  $where .= " AND (CAST(u.userid AS CHAR) LIKE ? OR u.username LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
}

$st = $pdo->prepare("SELECT COUNT(*)
                     FROM agent_charges c
                     LEFT JOIN users u ON u.uid = c.user_uid
                     WHERE $where");
$st->execute($params);
$total = (int)$st->fetchColumn();
$pages = max(1, (int)ceil($total / $perPage));

$sql = "SELECT
          c.id, c.user_uid, c.coins, c.status, c.error_code, c.ledger_id, c.created_at,
          u.userid, u.username, u.avatar_url
        FROM agent_charges c
        LEFT JOIN users u ON u.uid = c.user_uid
        WHERE $where
        ORDER BY c.id DESC
        LIMIT $perPage OFFSET $offset";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>سجل الشحن</title>
  <style>
    :root{
      --bg:#0b1220;--panel:#0f172a;--text:#e5e7eb;--sub:#94a3b8;
      --border:#243047;--primary:#3b82f6;--danger:#ef4444;--ok:#22c55e
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto}
    header{display:flex;gap:12px;align-items:center;justify-content:space-between;padding:12px 16px;border-bottom:1px solid var(--border);background:#0c1426}
    .wrap{max-width:1100px;margin:0 auto;padding:16px}
    .card{background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:16px}
    .form{display:flex;gap:8px;flex-wrap:wrap;align-items:center}
    .input{display:flex;align-items:center;gap:6px;background:#0c1426;border:1px solid var(--border);border-radius:12px;padding:6px 10px}
    .input input{border:none;outline:none;background:transparent;color:var(--text)}
    .btn{display:inline-block;padding:8px 12px;border-radius:10px;border:1px solid var(--border);background:#1a2336;color:var(--text);text-decoration:none}
    .btn.pri{background:var(--primary);color:#fff}
    .badge{display:inline-block;border:1px solid var(--border);padding:2px 8px;border-radius:999px;font-size:12px}
    .badge.ok{border-color:var(--ok)} .badge.err{border-color:var(--danger)}
    table{width:100%;border-collapse:separate;border-spacing:0}
    th,td{padding:12px;border-bottom:1px solid var(--border);text-align:start}
    thead th{background:#0b1220;position:sticky;top:0;z-index:2}
    .mono{font-family:ui-monospace,Menlo,Consolas,monospace}
    .muted{color:var(--sub)}
    .user{display:flex;align-items:center;gap:10px}
    .avatar{width:36px;height:36px;border-radius:999px;object-fit:cover;border:1px solid var(--border);background:#0c1426}
    .name{font-weight:700}
    .subline{font-size:12px;color:var(--sub)}
    /* اخفِ بطاقات الجوال افتراضيًا (عشان ما تتكرر بجانب الجدول) */
    .list{display:none}

    /* بطاقات للجوال */
    @media (max-width:860px){
      table{display:none}
      .list{display:grid;gap:10px}
      .item{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
      .top{display:flex;align-items:center;gap:10px}
      .top .meta{display:flex;flex-direction:column;gap:2px}
      .row{display:flex;justify-content:space-between;gap:8px;margin-top:6px}
      .kv{font-size:13px;color:var(--sub)}
    }
  </style>
</head>
<body>
<header>
  <div>سجل الشحن — الوكيل: <b><?= e2($agent['display_name'] ?? $agent['username'] ?? '') ?></b></div>
  <div>
    <a class="btn" href="dashboard.php">رجوع للوحة</a>
  </div>
</header>

<div class="wrap">
  <div class="card" style="margin-bottom:12px">
    <form method="get" class="form">
      <div class="input">
        <input type="text" name="q" value="<?= e2($q) ?>" placeholder="ابحث بـ UserID أو الاسم">
      </div>
      <button class="btn pri" type="submit">بحث</button>
      <?php if ($q!==''): ?><a class="btn" href="charges.php">مسح</a><?php endif; ?>
      <div style="margin-inline-start:auto;color:#94a3b8">إجمالي النتائج: <b><?= (int)$total ?></b></div>
    </form>
  </div>

  <div class="card">
    <!-- جدول سطح المكتب -->
    <table>
      <thead>
        <tr>
          <th>رقم</th>
          <th>التاريخ</th>
          <th>المستخدم</th>
          <th>الكوين</th>
          <th>الحالة</th>
          <th>دفتر</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r):
          $name   = (string)($r['username'] ?? '');
          $userid = (string)($r['userid'] ?? '');
          $avatar = (string)($r['avatar_url'] ?? '');
        ?>
          <tr>
            <td class="mono"><?= (int)$r['id'] ?></td>
            <td class="mono"><?= e2((string)($r['created_at'] ?? '')) ?></td>
            <td>
              <div class="user">
                <img class="avatar" src="<?= e2($avatar) ?>" alt="">
                <div>
                  <div class="name"><?= $name !== '' ? e2($name) : '—' ?></div>
                  <div class="subline">UserID: <span class="mono"><?= $userid !== '' ? e2($userid) : '—' ?></span></div>
                </div>
              </div>
            </td>
            <td class="mono"><?= (int)$r['coins'] ?></td>
            <td>
              <?php if (($r['status'] ?? '') === 'success'): ?>
                <span class="badge ok">ناجحة</span>
              <?php else: ?>
                <span class="badge err">فشلت</span>
              <?php endif; ?>
            </td>
            <td class="mono"><?= e2((string)($r['ledger_id'] ?? '')) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$rows): ?>
          <tr><td colspan="6" style="text-align:center;opacity:.7">لا نتائج</td></tr>
        <?php endif; ?>
      </tbody>
    </table>

    <!-- بطاقات للجوال -->
    <div class="list">
      <?php foreach ($rows as $r):
        $name   = (string)($r['username'] ?? '');
        $userid = (string)($r['userid'] ?? '');
        $avatar = (string)($r['avatar_url'] ?? '');
      ?>
        <div class="item">
          <div class="top">
            <img class="avatar" src="<?= e2($avatar) ?>" alt="">
            <div class="meta">
              <div class="name"><?= $name !== '' ? e2($name) : '—' ?></div>
              <div class="subline">UserID: <span class="mono"><?= $userid !== '' ? e2($userid) : '—' ?></span></div>
            </div>
            <div style="margin-inline-start:auto" class="subline mono"><?= e2((string)($r['created_at'] ?? '')) ?></div>
          </div>
          <div class="row"><div class="kv">الكوين</div><div class="mono"><?= (int)$r['coins'] ?></div></div>
          <div class="row"><div class="kv">الحالة</div>
            <div><?= (($r['status'] ?? '') === 'success') ? 'ناجحة' : 'فشلت' ?></div>
          </div>
          <?php if (!empty($r['ledger_id'])): ?>
            <div class="row"><div class="kv">دفتر</div><div class="mono"><?= e2((string)$r['ledger_id']) ?></div></div>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- صفحات -->
    <?php if ($pages > 1): ?>
      <div class="form" style="margin-top:10px">
        <?php for($p=1;$p<=$pages;$p++):
          $url = 'charges.php?page='.$p.($q!=='' ? '&q='.urlencode($q) : '');
          $is  = $p===$page; ?>
          <a href="<?= e2($url) ?>" class="btn"<?= $is?' style="pointer-events:none;opacity:.6"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
