<?php
// /public_html/voicechat/agents/_common.php
declare(strict_types=1);

/* تحميل الكونفيج من المسار الصحيح */
$loaded = false;
$try = [
  __DIR__ . '/../api/config.php',     // ← هذا هو الصحيح لمسارك
  dirname(__DIR__) . '/api/config.php',
  dirname(__DIR__) . '/config.php',
  __DIR__ . '/../config.php',
];
foreach ($try as $p) { if (is_file($p)) { require_once $p; $loaded = true; break; } }
if (!$loaded || !function_exists('db') || !function_exists('json_in') || !function_exists('json_out')) {
  http_response_code(500);
  echo "config.php not found or helpers missing";
  exit;
}

/* دوال مساعدة للـ API */
function agent_generate_token(): string { return bin2hex(random_bytes(32)); } // 64 hex

/** ارجع صف الوكيل من خلال توكن */
function agent_from_token(?string $bearer): ?array {
  if (!$bearer || !preg_match('~^Bearer\s+([A-Fa-f0-9]{64})$~', $bearer, $m)) return null;
  $token = $m[1];
  $pdo = db();
  $st = $pdo->prepare("SELECT a.* FROM agent_tokens t JOIN agents a ON a.id=t.agent_id WHERE t.token=? AND t.expires_at>NOW() LIMIT 1");
  $st->execute([$token]);
  return $st->fetch() ?: null;
}

/** يجبر على وجود وكيل (يرد 401/403 عند الفشل) */
function require_agent(): array {
  $auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  $agent = agent_from_token($auth);
  if (!$agent) json_out(['ok'=>false,'error'=>'agent_unauthorized'], 401);
  if (($agent['status'] ?? '') !== 'active') json_out(['ok'=>false,'error'=>'agent_suspended'], 403);
  return $agent;
}

/** تخزين IP كثنائية (بدون INET6_ATON لتفادي اختلاف الإصدارات) */
function ip_bin_or_null(): ?string {
  $ip = $_SERVER['REMOTE_ADDR'] ?? null;
  if (!$ip) return null;
  $bin = @inet_pton($ip);
  return $bin ?: null;
}
