<?php
// admin/util/seed_admin.php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';

$pdo = db();

// عدل البيانات كما تريد
$username = 'admin';
$email    = 'admin@example.com';
$full     = 'Super Admin';
$pass     = 'admin123'; // غيّرها فورًا بعد الدخول الأول
$hash     = password_hash($pass, PASSWORD_DEFAULT);

$pdo->exec("CREATE TABLE IF NOT EXISTS admincp (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(64) UNIQUE,
  email VARCHAR(190) UNIQUE,
  full_name VARCHAR(190),
  password_hash VARCHAR(255) NOT NULL,
  role VARCHAR(32) DEFAULT 'superadmin',
  is_active TINYINT(1) DEFAULT 1,
  last_login_at DATETIME NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");

$st = $pdo->prepare("SELECT id FROM admincp WHERE email=? OR username=? LIMIT 1");
$st->execute([$email, $username]);
if ($st->fetch()) {
  echo "يوجد مستخدم بنفس البريد/المستخدم بالفعل.";
  exit;
}

$st = $pdo->prepare("INSERT INTO admincp (username,email,full_name,password_hash,role,is_active) VALUES (?,?,?,?,?,1)");
$st->execute([$username,$email,$full,$hash,'superadmin']);

echo "تم إنشاء الأدمن بنجاح. المستخدم: {$username} | كلمة المرور: {$pass}";
