<?php
// admin/rooms_edit.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

/* === (اختياري أثناء التشخيص – احذفه في الإنتاج) === */
// ini_set('display_errors', '1'); error_reporting(E_ALL);

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));

/* حارس لمنع إعادة التعريف إذا كانت موجودة في ملفات مشتركة */
if (!function_exists('csrf_token')) {
  function csrf_token(): string { return $_SESSION['csrf']; }
}
if (!function_exists('csrf_ok')) {
  function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
}
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('rooms.php');

$msg = null; $err = null;

/* جلب بيانات الغرفة */
$st = $pdo->prepare("SELECT * FROM rooms WHERE id=? LIMIT 1");
$st->execute([$id]);
$room = $st->fetch(PDO::FETCH_ASSOC);
if (!$room) redirect('rooms.php');

/* حفظ التعديلات */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $name    = trim($_POST['name'] ?? '');
    $desc    = trim($_POST['description'] ?? '');
    $owner   = trim($_POST['owner_uid'] ?? '');
    $uid     = trim($_POST['uid'] ?? '');
    $agora   = trim($_POST['agora_channel'] ?? '');
    $status  = (($_POST['status'] ?? 'open') === 'closed') ? 'closed' : 'open';
    $seats   = max(1, (int)($_POST['max_seats'] ?? 8));
    $img     = trim($_POST['image_url'] ?? '');
    $bg      = trim($_POST['background_url'] ?? '');

    $desc = ($desc !== '') ? $desc : null;
    $img  = ($img  !== '') ? $img  : null;
    $bg   = ($bg   !== '') ? $bg   : null;

    try {
      $sql = "UPDATE rooms
                 SET name=?, description=?, owner_uid=?, uid=?, agora_channel=?,
                     status=?, max_seats=?, image_url=?, background_url=?
               WHERE id=? LIMIT 1";
      $pdo->prepare($sql)->execute([
        $name, $desc, $owner, $uid, $agora,
        $status, $seats, $img, $bg, $id
      ]);

      $msg = 'تم الحفظ بنجاح.';
      $st = $pdo->prepare("SELECT * FROM rooms WHERE id=? LIMIT 1");
      $st->execute([$id]);
      $room = $st->fetch(PDO::FETCH_ASSOC);
    } catch (Throwable $e) {
      // يمكنك تسجيل $e->getMessage() في لوج السيرفر
      $err = 'حدث خطأ أثناء الحفظ.';
    }
  }
}

$PAGE_TITLE = "تعديل غرفة #{$id}";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
  <div class="card" style="max-width:900px;">
    <h1>تعديل غرفة #<?= (int)$room['id'] ?></h1>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form class="form" method="post">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

      <div class="grid cols-2">
        <div class="input">
          <label>اسم الغرفة</label>
          <input name="name" value="<?= e($room['name'] ?? '') ?>" required>
        </div>
        <div class="input">
          <label>المالك (owner_uid)</label>
          <input name="owner_uid" value="<?= e($room['owner_uid'] ?? '') ?>">
        </div>

        <div class="input" style="grid-column:1 / -1;">
          <label>الوصف</label>
          <input name="description" value="<?= e($room['description'] ?? '') ?>">
        </div>

        <div class="input">
          <label>UID</label>
          <input name="uid" value="<?= e($room['uid'] ?? '') ?>">
        </div>
        <div class="input">
          <label>قناة Agora</label>
          <input name="agora_channel" value="<?= e($room['agora_channel'] ?? '') ?>">
        </div>

        <div class="input">
          <label>الحالة</label>
          <input list="room-status" name="status" value="<?= e($room['status'] ?? 'open') ?>">
          <datalist id="room-status">
            <option value="open">
            <option value="closed">
          </datalist>
        </div>
        <div class="input">
          <label>عدد المقاعد</label>
          <input type="number" name="max_seats" min="1" step="1" value="<?= (int)($room['max_seats'] ?? 8) ?>">
        </div>

        <div class="input">
          <label>صورة الغرفة (URL)</label>
          <input name="image_url" value="<?= e($room['image_url'] ?? '') ?>">
        </div>
        <div class="input">
          <label>خلفية الغرفة (URL)</label>
          <input name="background_url" value="<?= e($room['background_url'] ?? '') ?>">
        </div>
      </div>

      <div style="display:flex; gap:8px; margin-top:8px;">
        <button class="btn" type="submit">حفظ</button>
        <a class="btn secondary" href="rooms.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
<?php require __DIR__ . '/inc/footer.php'; ?>
