<?php
// admin/index.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

$pdo = db();

/* --------- أرقام إجمالية --------- */
$counts = [
  'users'        => (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
  'rooms'        => (int)$pdo->query("SELECT COUNT(*) FROM rooms")->fetchColumn(),
  'posts'        => (int)$pdo->query("SELECT COUNT(*) FROM moment_posts")->fetchColumn(),
  'comments'     => (int)$pdo->query("SELECT COUNT(*) FROM moment_comments")->fetchColumn(),
  'joins'        => (int)$pdo->query("SELECT COUNT(*) FROM join_room")->fetchColumn(),
  'gift_items'   => (int)$pdo->query("SELECT COUNT(*) FROM gift_items")->fetchColumn(),
  'gift_cats'    => (int)$pdo->query("SELECT COUNT(*) FROM gift_categories")->fetchColumn(),
  'gift_tx'      => (int)$pdo->query("SELECT COUNT(*) FROM gift_transactions")->fetchColumn(),
  'staff'        => (int)$pdo->query("SELECT COUNT(*) FROM admincp")->fetchColumn(),
  'staff_active' => (int)$pdo->query("SELECT COUNT(*) FROM admincp WHERE is_active=1")->fetchColumn(),
];

/* --------- نشاط اليوم --------- */
$today = date('Y-m-d');
$today_metrics = [
  'new_users'      => (int)($pdo->query("SELECT COUNT(*) FROM users WHERE DATE(created_at)=DATE('$today')")->fetchColumn() ?: 0),
  'posts_today'    => (int)($pdo->query("SELECT COUNT(*) FROM moment_posts WHERE DATE(created_at)=DATE('$today')")->fetchColumn() ?: 0),
  'comments_today' => (int)($pdo->query("SELECT COUNT(*) FROM moment_comments WHERE DATE(created_at)=DATE('$today')")->fetchColumn() ?: 0),
  'joins_today'    => (int)($pdo->query("SELECT COUNT(*) FROM join_room WHERE DATE(created_at)=DATE('$today')")->fetchColumn() ?: 0),
];

/* --------- أفضل الغرف آخر 7 أيام --------- */
$topRooms = [];
try {
  $st = $pdo->prepare("
    SELECT jr.room_uid, COUNT(*) AS c, r.name
    FROM join_room jr
    LEFT JOIN rooms r ON r.uid = jr.room_uid
    WHERE jr.created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)
    GROUP BY jr.room_uid, r.name
    ORDER BY c DESC
    LIMIT 5
  ");
  $st->execute();
  $topRooms = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {}

/* --------- أحدث المستخدمين --------- */
$latestUsers = [];
try {
  $st = $pdo->query("SELECT id, username, email, created_at, avatar_url FROM users ORDER BY created_at DESC, id DESC LIMIT 5");
  $latestUsers = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {}

/* --------- أحدث منشورات اللحظات --------- */
$latestPosts = [];
try {
  $st = $pdo->query("SELECT id, content_text, created_at, likes_count, comments_count FROM moment_posts ORDER BY created_at DESC, id DESC LIMIT 5");
  $latestPosts = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {}

$u = current_user();
$PAGE_TITLE = "الرئيسية";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.dash .stats{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:12px}
@media (max-width:1200px){.dash .stats{grid-template-columns:repeat(3,minmax(0,1fr))}}
@media (max-width:900px){.dash .stats{grid-template-columns:repeat(2,minmax(0,1fr))}}
@media (max-width:600px){.dash .stats{grid-template-columns:1fr}}
.stat-card{display:block;padding:14px;border:1px solid var(--border);border-radius:12px;background:var(--panel);text-decoration:none;color:var(--text)}
.stat-card .k{font-size:28px;font-weight:800;line-height:1;margin-bottom:6px}
.stat-card .t{opacity:.9}
.stat-card .i{font-size:22px;opacity:.85}
.stat-card:hover{transform:translateY(-2px);transition:.12s;background:rgba(59,130,246,.08)}
.section-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px}
@media (max-width:1100px){.section-grid{grid-template-columns:1fr}}
.simple-table{width:100%;border-collapse:separate;border-spacing:0;border:1px solid var(--border);border-radius:12px;overflow:hidden}
.simple-table th,.simple-table td{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle}
.simple-table thead th{background:#0b1220;font-weight:700}
.ellipsis{max-width:320px;display:inline-block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}
.badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.badge.ok{border-color:#22c55e}
</style>

<div class="dash">
  <div class="card" style="margin-bottom:12px;">
    <h1>مرحبًا بك، <?= e($u['name'] ?? 'مستخدم') ?> 👋</h1>
    <div style="opacity:.8">نظرة سريعة على أهم الأرقام.</div>
  </div>

  <!-- بطاقات إحصائية سريعة -->
  <div class="stats">
    <a class="stat-card" href="users.php">
      <div class="i">👥</div><div class="k"><?= number_format($counts['users']) ?></div><div class="t">إجمالي المستخدمين</div>
    </a>
    <a class="stat-card" href="rooms.php">
      <div class="i">🎙️</div><div class="k"><?= number_format($counts['rooms']) ?></div><div class="t">عدد الغرف</div>
    </a>
    <a class="stat-card" href="moments.php">
      <div class="i">🖼️</div><div class="k"><?= number_format($counts['posts']) ?></div><div class="t">منشورات اللحظات</div>
    </a>
    <a class="stat-card" href="comments.php">
      <div class="i">💬</div><div class="k"><?= number_format($counts['comments']) ?></div><div class="t">تعليقات اللحظات</div>
    </a>
    <a class="stat-card" href="join_stats.php">
      <div class="i">🧩</div><div class="k"><?= number_format($counts['joins']) ?></div><div class="t">إجمالي الانضمامات للغرف</div>
    </a>
    <a class="stat-card" href="gifts.php">
      <div class="i">🎁</div><div class="k"><?= number_format($counts['gift_items']) ?></div><div class="t">هدايا متاحة</div>
    </a>
    <a class="stat-card" href="gift_transactions.php">
      <div class="i">📜</div><div class="k"><?= number_format($counts['gift_tx']) ?></div><div class="t">سجل الهدايا</div>
    </a>
    <a class="stat-card" href="staff.php">
      <div class="i">🧑‍💼</div><div class="k"><?= number_format($counts['staff_active']) ?>/<?= number_format($counts['staff']) ?></div><div class="t">الموظفون (مفعل/إجمالي)</div>
    </a>
  </div>

  <!-- نشاط اليوم + أفضل الغرف -->
  <div class="grid cols-2" style="margin-top:12px;">
    <div class="card">
      <h2>نشاط اليوم</h2>
      <div style="display:flex;gap:10px;flex-wrap:wrap;">
        <span class="badge ok">مستخدمون جدد: <?= number_format($today_metrics['new_users']) ?></span>
        <span class="badge">منشورات: <?= number_format($today_metrics['posts_today']) ?></span>
        <span class="badge">تعليقات: <?= number_format($today_metrics['comments_today']) ?></span>
        <span class="badge">انضمامات للغرف: <?= number_format($today_metrics['joins_today']) ?></span>
      </div>
    </div>

    <div class="card">
      <h2>أفضل الغرف آخر 7 أيام</h2>
      <table class="simple-table">
        <thead><tr><th>#</th><th>الغرفة</th><th>Room UID</th><th>انضمامات</th></tr></thead>
        <tbody>
          <?php $i=1; foreach ($topRooms as $r): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td class="ellipsis"><?= e($r['name'] ?? '') ?></td>
              <td><span class="badge"><?= e($r['room_uid']) ?></span></td>
              <td><b><?= (int)$r['c'] ?></b></td>
            </tr>
          <?php endforeach; if (!$topRooms): ?>
            <tr><td colspan="4" style="text-align:center;opacity:.7;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- أحدث المستخدمين / أحدث المنشورات -->
  <div class="section-grid" style="margin-top:12px;">
    <div class="card">
      <h2>أحدث المستخدمين</h2>
      <table class="simple-table">
        <thead><tr><th>#</th><th>الاسم</th><th>الإيميل</th><th>أُنشيء</th></tr></thead>
        <tbody>
          <?php foreach ($latestUsers as $row): ?>
            <tr>
              <td><?= (int)$row['id'] ?></td>
              <td class="ellipsis"><?= e($row['username'] ?? '') ?></td>
              <td class="ellipsis"><?= e($row['email'] ?? '') ?></td>
              <td><?= e(substr((string)$row['created_at'],0,16)) ?></td>
            </tr>
          <?php endforeach; if (!$latestUsers): ?>
            <tr><td colspan="4" style="text-align:center;opacity:.7;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="card">
      <h2>أحدث منشورات اللحظات</h2>
      <table class="simple-table">
        <thead><tr><th>#</th><th>النص</th><th>تعليقات</th><th>إعجابات</th><th>أُنشيء</th></tr></thead>
        <tbody>
          <?php foreach ($latestPosts as $p): ?>
            <tr>
              <td><?= (int)$p['id'] ?></td>
              <td class="ellipsis" title="<?= e($p['content_text'] ?? '') ?>"><?= e($p['content_text'] ?? '') ?></td>
              <td><?= (int)$p['comments_count'] ?></td>
              <td><?= (int)$p['likes_count'] ?></td>
              <td><?= e(substr((string)$p['created_at'],0,16)) ?></td>
            </tr>
          <?php endforeach; if (!$latestPosts): ?>
            <tr><td colspan="5" style="text-align:center;opacity:.7;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php require __DIR__ . '/inc/footer.php'; ?>
