<?php
// admin/gifts.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

/* مساعدين لتحديد نوع الميديا */
function url_ext(?string $url): string {
  if (!$url) return '';
  $path = parse_url($url, PHP_URL_PATH) ?? '';
  return strtolower(pathinfo($path, PATHINFO_EXTENSION));
}
function is_lottie(?string $url): bool {
  $ext = url_ext($url);
  return in_array($ext, ['json','lottie'], true);
}
function is_video(?string $url): bool {
  return url_ext($url) === 'mp4';
}
function is_gif(?string $url): bool {
  return url_ext($url) === 'gif';
}

$pdo = db();
$msg = null; $err = null;

/* أفعال */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  $id     = (int)($_POST['id'] ?? 0);
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } elseif ($id <= 0) {
    $err = 'مُعرّف غير صالح.';
  } else {
    try {
      if ($action === 'toggle_active') {
        $pdo->prepare("UPDATE `gift_items` SET `is_active`=1-`is_active` WHERE `id`=? LIMIT 1")->execute([$id]);
        $msg = 'تم تبديل الحالة.';
      } elseif ($action === 'delete_gift') {
        $pdo->prepare("DELETE FROM `gift_items` WHERE `id`=? LIMIT 1")->execute([$id]);
        $msg = 'تم حذف الهدية.';
      }
    } catch (Throwable $e) {
      $err = 'تعذّر تنفيذ العملية.';
    }
  }
}

/* فلاتر/بحث/ترقيم */
$q        = trim($_GET['q'] ?? '');
$catF     = (int)($_GET['category_id'] ?? 0);
$activeF  = trim($_GET['active'] ?? ''); // '', 1, 0
$page     = max(1, (int)($_GET['page'] ?? 1));
$perPage  = 50;
$offset   = ($page - 1) * $perPage;

/* أسماء التصنيفات */
$catNames = [];
try {
  $res = $pdo->query("SELECT id,name FROM `gift_categories` ORDER BY sort_order ASC, id ASC");
  foreach ($res?->fetchAll() ?? [] as $c) $catNames[(int)$c['id']] = (string)$c['name'];
} catch (Throwable $e) {}

/* شرط البحث */
$where = "1=1"; $params=[];
if ($q!==''){
  // ابحث بالاسم + جزء من الروابط
  $where.=" AND (gi.name LIKE ? OR gi.image_url LIKE ? OR gi.video_url LIKE ?)";
  $params[]="%$q%"; $params[]="%$q%"; $params[]="%$q%";
}
if ($catF>0){ $where.=" AND gi.category_id=?"; $params[]=$catF; }
if ($activeF==='1'){ $where.=" AND gi.is_active=1"; }
elseif ($activeF==='0'){ $where.=" AND gi.is_active=0"; }

/* عدّ إجمالي */
$st = $pdo->prepare("SELECT COUNT(*) FROM `gift_items` gi WHERE $where");
$st->execute($params); $total=(int)$st->fetchColumn();
$pages = max(1,(int)ceil($total/$perPage));

/* جلب الصفحة — لاحظ أننا نجلب أيضًا video_url/fullscreen/video_crop_right */
$sql = "SELECT gi.id,gi.category_id,gi.name,gi.image_url,gi.video_url,gi.fullscreen,gi.video_crop_right,
               gi.price,gi.sort_order,gi.is_active,gi.created_at
        FROM `gift_items` gi
        WHERE $where
        ORDER BY gi.sort_order ASC, gi.id ASC
        LIMIT $perPage OFFSET $offset";
$st=$pdo->prepare($sql); $st->execute($params);
$rows=$st->fetchAll();

$PAGE_TITLE="الهدايا";
require __DIR__.'/inc/header.php';
require __DIR__.'/inc/sidebar.php';
?>
<style>
.gifts .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.gifts .table td,.gifts .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.gifts .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.gifts .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.gifts .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.gifts .table-wrap{max-height:70vh;overflow:auto;position:relative}
.gifts .td-center{text-align:center}
.gifts .ellipsis{max-width:280px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.gifts .gift-img{width:52px;height:52px;border-radius:10px;object-fit:cover;border:1px solid var(--border);background:#0d111a}
.gifts .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.gifts .badge.ok{border-color:#22c55e}
.gifts .badge.warn{border-color:#f59e0b}
.gifts .actions{display:flex;gap:8px;flex-wrap:nowrap;align-items:center}
.gifts .btn.sm{padding:6px 10px;font-size:14px}
.gifts .col-id{width:56px}.gifts .col-img{width:76px}.gifts .col-name{width:220px}.gifts .col-cat{width:140px}
.gifts .col-price{width:90px}.gifts .col-sort{width:80px}.gifts .col-active{width:96px}.gifts .col-created{width:160px}
.gifts .col-video{width:240px}.gifts .col-full{width:88px}.gifts .col-crop{width:88px}.gifts .col-actions{width:300px}
.gifts .mini{font-size:11px;opacity:.85}
</style>

<div class="gifts">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
      <div class="input" style="min-width:260px;flex:1;">
        <label>ابحث (اسم/رابط)</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="مثال: VIP أو mp4 أو json">
      </div>
      <div class="input">
        <label>التصنيف</label>
        <select name="category_id" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value="0" <?= $catF===0?'selected':'' ?>>الكل</option>
          <?php foreach ($catNames as $cid=>$name): ?>
            <option value="<?= (int)$cid ?>" <?= $catF===$cid?'selected':'' ?>><?= e($name) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="input">
        <label>الحالة</label>
        <select name="active" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value=""  <?= $activeF===''?'selected':'' ?>>الكل</option>
          <option value="1" <?= $activeF==='1'?'selected':'' ?>>مفعل</option>
          <option value="0" <?= $activeF==='0'?'selected':'' ?>>معطل</option>
        </select>
      </div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($q!=='' || $catF>0 || $activeF!==''): ?>
        <a class="btn sm secondary" href="gifts.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">إجمالي: <b><?= $total ?></b> نتيجة</div>
      <a class="btn sm" href="gifts_add.php">+ إضافة هدية</a>
    </form>
    <?php if($msg):?><div class="alert" style="margin-top:12px;border-color:#22c55e;"><?=e($msg)?></div><?php endif;?>
    <?php if($err):?><div class="alert" style="margin-top:12px;"><?=e($err)?></div><?php endif;?>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-img"><col class="col-name"><col class="col-cat">
          <col class="col-price"><col class="col-sort"><col class="col-active">
          <col class="col-video"><col class="col-full"><col class="col-crop">
          <col class="col-created"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th class="td-center">المعاينة</th>
            <th>الاسم</th>
            <th>التصنيف</th>
            <th>السعر</th>
            <th>الترتيب</th>
            <th>الحالة</th>
            <th>رابط الفيديو</th>
            <th class="td-center">ملء الشاشة</th>
            <th class="td-center">قص يمين</th>
            <th>أُنشيء</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r):
            $img = (string)($r['image_url'] ?? '');
            $vid = (string)($r['video_url'] ?? '');
            $mediaBadge = '';
            if ($vid && is_video($vid))        $mediaBadge = '<span class="badge warn">MP4</span>';
            elseif ($img && is_lottie($img))   $mediaBadge = '<span class="badge">Lottie</span>';
            elseif ($img && is_gif($img))      $mediaBadge = '<span class="badge">GIF</span>';
            ?>
            <tr>
              <td class="td-center"><?= (int)$r['id'] ?></td>

              <!-- المعاينة: صورة إن كانت صورة / لون داكن + شارة للميديا الخاصة -->
              <td class="td-center">
                <?php if($img && !is_video($img) && !is_lottie($img)): ?>
                  <img src="<?= e($img) ?>" class="gift-img" alt="">
                  <?php if ($mediaBadge): ?><div class="mini" style="margin-top:4px;"><?= $mediaBadge ?></div><?php endif; ?>
                <?php else: ?>
                  <div class="gift-img" style="display:flex;align-items:center;justify-content:center;">
                    <?= $mediaBadge ?: '<span class="mini">—</span>' ?>
                  </div>
                <?php endif; ?>
              </td>

              <td title="<?= e($r['name'] ?? '') ?>"><span class="ellipsis"><?= e($r['name'] ?? '') ?></span></td>
              <td><?= e($catNames[(int)$r['category_id']] ?? ('#'.(int)$r['category_id'])) ?></td>
              <td class="td-center"><span class="badge ok"><?= e((string)$r['price']) ?></span></td>
              <td class="td-center"><?= (int)$r['sort_order'] ?></td>
              <td class="td-center"><?= ((int)$r['is_active']===1)?'<span class="badge ok">مفعل</span>':'<span class="badge">معطل</span>' ?></td>

              <!-- رابط الفيديو إن وجد -->
              <td>
                <?php if ($vid): ?>
                  <a class="ellipsis" href="<?= e($vid) ?>" target="_blank" rel="noopener"><?= e($vid) ?></a>
                <?php else: ?>
                  <span class="mini" style="opacity:.7">—</span>
                <?php endif; ?>
              </td>

              <!-- ملء الشاشة -->
              <td class="td-center">
                <?= ((int)($r['fullscreen'] ?? 0)===1) ? '<span class="badge ok">نعم</span>' : '<span class="badge">لا</span>' ?>
              </td>

              <!-- قص يمين -->
              <td class="td-center">
                <?php
                  $crop = $r['video_crop_right'];
                  echo ($crop === null || $crop==='') ? '<span class="mini" style="opacity:.7">—</span>' : e((string)$crop);
                ?>
              </td>

              <td title="<?= e($r['created_at'] ?? '') ?>"><?= fmt_dt($r['created_at'] ?? '') ?></td>

              <td class="actions">
                <!-- تعديل -->
                <a class="btn sm" href="gifts_add.php?id=<?= (int)$r['id'] ?>">تعديل</a>

                <!-- تفعيل/تعطيل -->
                <form method="post" onsubmit="return confirm('تبديل الحالة ؟');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="toggle_active">
                  <button class="btn sm" type="submit"><?= ((int)$r['is_active']===1)?'تعطيل':'تفعيل' ?></button>
                </form>

                <!-- حذف -->
                <form method="post" onsubmit="return confirm('حذف نهائي للهدية؟');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="delete_gift">
                  <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?>
            <tr><td colspan="12" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='gifts.php?page='.$p
            .($q!==''?'&q='.urlencode($q):'')
            .($catF>0?'&category_id='.$catF:'')
            .($activeF!==''?'&active='.$activeF:'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require __DIR__.'/inc/footer.php'; ?>
