<?php
// admin/gift_categories.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_dt(?string $s): string { $t=strtotime((string)$s); return $t>0?date('Y-m-d H:i',$t):''; }

$pdo = db();
$msg=null; $err=null;

/* أفعال */
if ($_SERVER['REQUEST_METHOD']==='POST'){
  if (!csrf_ok($_POST['csrf'] ?? '')) { $err='رمز الأمان غير صالح.'; }
  else {
    $action=$_POST['action'] ?? '';
    if ($action==='add'){
      $name=trim($_POST['name'] ?? ''); $sort=(int)($_POST['sort_order'] ?? 0); $active=(int)($_POST['is_active'] ?? 1);
      if ($name==='') $err='الاسم مطلوب.';
      if (!$err){
        try{
          $pdo->prepare("INSERT INTO `gift_categories`(name,sort_order,is_active,created_at) VALUES (?,?,?,NOW())")
              ->execute([$name,$sort,$active]);
          $msg='تمت إضافة التصنيف.';
        }catch(Throwable $e){ $err='تعذّر الإضافة.'; }
      }
    } elseif ($action==='update'){
      $id=(int)($_POST['id'] ?? 0); $name=trim($_POST['name'] ?? ''); $sort=(int)($_POST['sort_order'] ?? 0); $active=(int)($_POST['is_active'] ?? 1);
      if ($id<=0 || $name==='') $err='بيانات غير صالحة.';
      if (!$err){
        try{
          $pdo->prepare("UPDATE `gift_categories` SET name=?, sort_order=?, is_active=? WHERE id=? LIMIT 1")
              ->execute([$name,$sort,$active,$id]);
          $msg='تم حفظ التعديل.';
        }catch(Throwable $e){ $err='تعذّر الحفظ.'; }
      }
    } elseif ($action==='delete'){
      $id=(int)($_POST['id'] ?? 0);
      if ($id>0){
        try{ $pdo->prepare("DELETE FROM `gift_categories` WHERE id=? LIMIT 1")->execute([$id]); $msg='تم الحذف.'; }
        catch(Throwable $e){ $err='تعذّر الحذف.'; }
      }
    }
  }
}

/* قراءة */
$rows=[];
try{
  $res=$pdo->query("SELECT * FROM `gift_categories` ORDER BY sort_order ASC, id ASC");
  $rows=$res?->fetchAll() ?? [];
}catch(Throwable $e){}

$PAGE_TITLE="فئات الهدايا";
require __DIR__.'/inc/header.php';
require __DIR__.'/inc/sidebar.php';
?>
<style>
.cats .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.cats .table td,.cats .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.cats .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.cats .td-center{text-align:center}
.cats .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.cats .badge.ok{border-color:#22c55e}
.cats .actions{display:flex;gap:8px;align-items:center}
.cats .btn.sm{padding:6px 10px;font-size:14px}
.cats .col-id{width:60px}.cats .col-name{width:280px}.cats .col-sort{width:110px}.cats .col-active{width:100px}.cats .col-created{width:170px}.cats .col-actions{width:260px}
</style>

<div class="cats">
  <div class="card" style="margin-bottom:16px;">
    <?php if($msg):?><div class="alert" style="border-color:#22c55e;"><?=e($msg)?></div><?php endif;?>
    <?php if($err):?><div class="alert"><?=e($err)?></div><?php endif;?>

    <form class="form" method="post" style="display:flex;gap:12px;flex-wrap:wrap;align-items:flex-end;">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="add">
      <div class="input">
        <label>اسم التصنيف</label>
        <input name="name" required>
      </div>
      <div class="input">
        <label>الترتيب</label>
        <input type="number" name="sort_order" value="1">
      </div>
      <div class="input">
        <label>الحالة</label>
        <select name="is_active" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value="1">مفعل</option>
          <option value="0">معطل</option>
        </select>
      </div>
      <button class="btn sm" type="submit">+ إضافة تصنيف</button>
    </form>
  </div>

  <div class="card">
    <table class="table">
      <colgroup>
        <col class="col-id"><col class="col-name"><col class="col-sort"><col class="col-active"><col class="col-created"><col class="col-actions">
      </colgroup>
      <thead>
        <tr>
          <th class="td-center">#</th><th>الاسم</th><th>الترتيب</th><th>الحالة</th><th>أُنشيء</th><th>إجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td class="td-center"><?= (int)$r['id'] ?></td>
            <td>
              <form method="post" style="display:flex;gap:8px;align-items:center;">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <input name="name" value="<?= e($r['name'] ?? '') ?>" style="width:220px">
                <input type="number" name="sort_order" value="<?= (int)$r['sort_order'] ?>" style="width:90px">
                <select name="is_active" style="padding:8px 10px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);width:110px">
                  <option value="1" <?= ((int)$r['is_active']===1)?'selected':''; ?>>مفعل</option>
                  <option value="0" <?= ((int)$r['is_active']===0)?'selected':''; ?>>معطل</option>
                </select>
                <button class="btn sm" type="submit">حفظ</button>
              </form>
            </td>
            <td class="td-center"><?= (int)$r['sort_order'] ?></td>
            <td class="td-center"><?= ((int)$r['is_active']===1)?'<span class="badge ok">مفعل</span>':'<span class="badge">معطل</span>' ?></td>
            <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
            <td class="actions">
              <form method="post" onsubmit="return confirm('حذف التصنيف؟');">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="6" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif;?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__.'/inc/footer.php'; ?>
