<?php
// admin/emojis_add.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$msg=null; $err=null;
$id = (int)($_GET['id'] ?? 0);

/* فئات */
$cats = $pdo->query("SELECT id,name FROM emoji_categories ORDER BY sort_order ASC, id ASC")->fetchAll();

/* تحميل السطر عند التعديل */
$row = ['id'=>0,'name'=>'','category_id'=>0,'image_url'=>'','animated'=>0,'sort_order'=>0];
if ($id>0) {
  $st=$pdo->prepare("SELECT * FROM emojis WHERE id=? LIMIT 1"); $st->execute([$id]);
  if ($r=$st->fetch()) $row=$r;
}

/* حفظ */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    $id   = (int)($_POST['id'] ?? 0);
    $name = trim((string)($_POST['name'] ?? ''));
    $cat  = (int)($_POST['category_id'] ?? 0);
    $anim = (int)($_POST['animated'] ?? 0);
    $sort = (int)($_POST['sort_order'] ?? 0);
    $img  = trim((string)($_POST['image_url'] ?? ''));

    /* رفع ملف اختياري (صور أو Lottie) */
    if (!empty($_FILES['image_file']['name']) && $_FILES['image_file']['error']===UPLOAD_ERR_OK) {
      $fn  = $_FILES['image_file']['name'];
      $tmp = $_FILES['image_file']['tmp_name'];
      $ext = strtolower(pathinfo($fn, PATHINFO_EXTENSION));

      $allowed = ['png','webp','jpg','jpeg','gif','json','lottie'];
      if (!in_array($ext, $allowed, true)) {
        $err='صيغة الملف غير مسموحة. الصيغ المسموحة: PNG, WEBP, JPG, GIF, JSON (Lottie), LOTTIE.'; goto out;
      }

      // مسار عام كما طلبت: /voicechat/files/emoji
      $publicBase = '/voicechat/files/emoji';
      $docroot = rtrim($_SERVER['DOCUMENT_ROOT'] ?? dirname(__DIR__, 2), '/');
      $dir = $docroot . $publicBase;

      if (!is_dir($dir)) @mkdir($dir, 0775, true);

      $base = 'emoji_'.time().'_'.bin2hex(random_bytes(3)).'.'.$ext;
      $dest = $dir . '/' . $base;

      if (!move_uploaded_file($tmp, $dest)) { $err='فشل رفع الملف.'; goto out; }

      // إن كان JSON نحاول التحقق أنه Lottie
      if ($ext === 'json') {
        $data = @file_get_contents($dest);
        $dec  = @json_decode((string)$data, true);
        $looksLottie = is_array($dec) && isset($dec['v']) && (isset($dec['layers']) || isset($dec['assets']));
        if (!$looksLottie) {
          @unlink($dest);
          $err='ملف JSON لا يبدو Lottie صالحًا.'; goto out;
        }
        $anim = 1; // Lottie متحرّك
      }

      // .lottie (ملف zip خاص بـ Lottie) نعتبره متحرك
      if ($ext === 'lottie') {
        $anim = 1;
      }

      // GIF غالبًا متحرك
      if ($ext === 'gif') {
        $anim = 1;
      }

      $img = $publicBase . '/' . $base; // رابط عام يُخزَّن في قاعدة البيانات
    }

    if ($name==='') $name='بدون اسم';
    if ($img==='') { $err='الصورة/الملف مطلوب (رابط أو رفع ملف).'; goto out; }

    try{
      if ($id>0) {
        $pdo->prepare("UPDATE emojis SET name=?, category_id=?, image_url=?, animated=?, sort_order=? WHERE id=? LIMIT 1")
            ->execute([$name,$cat,$img,$anim,$sort,$id]);
        $msg='تم التحديث.';
      } else {
        $pdo->prepare("INSERT INTO emojis (name,category_id,image_url,animated,sort_order) VALUES (?,?,?,?,?)")
            ->execute([$name,$cat,$img,$anim,$sort]);
        $msg='تمت الإضافة.';
      }
      // تحميل القيم الحديثة
      if ($id>0){ $st=$pdo->prepare("SELECT * FROM emojis WHERE id=?"); $st->execute([$id]); $row=$st->fetch(); }
      else { $row = ['id'=>0,'name'=>'','category_id'=>0,'image_url'=>'','animated'=>0,'sort_order'=>0]; }
    }catch(Throwable $e){ $err='تعذر الحفظ.'; }
  }
}
out:

$PAGE_TITLE = ($row['id']? 'تعديل ايموجي #'.$row['id'] : 'إضافة ايموجي');
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.eadd-page .hint{opacity:.8;font-size:12px}
.eadd-page .thumb{width:72px;height:72px;object-fit:contain;background:#0d111a;border:1px solid var(--border);border-radius:10px}
.eadd-page .badge{display:inline-block;padding:4px 8px;border:1px solid var(--border);border-radius:6px;font-size:12px;opacity:.9}
</style>

<div class="eadd-page">
  <div class="card" style="max-width:880px;">
    <h1 style="margin-top:0"><?= e($PAGE_TITLE) ?></h1>
    <?php if($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">

      <div class="grid cols-2">
        <div class="input">
          <label>الاسم</label>
          <input name="name" value="<?= e($row['name']) ?>" required>
        </div>

        <div class="input">
          <label>الفئة</label>
          <select name="category_id" required>
            <option value="">اختر فئة…</option>
            <?php foreach($cats as $c): ?>
              <option value="<?= (int)$c['id'] ?>"<?= ((int)$row['category_id']===(int)$c['id'])?' selected':''; ?>><?= e($c['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="input">
          <label>الرابط (صورة أو Lottie)</label>
          <input name="image_url" value="<?= e($row['image_url']) ?>" placeholder="https://…">
          <div class="hint">يمكن تركه فارغًا إذا استخدمت خانة رفع الملف بالأسفل. يدعم روابط صور أو ملفات Lottie (.json / .lottie).</div>
        </div>

        <div class="input">
          <label>ملف (صورة أو Lottie)</label>
          <input type="file" name="image_file" accept=".png,.webp,.jpg,.jpeg,.gif,.json,.lottie">
          <div class="hint">يدعم PNG / WEBP / JPG / GIF / JSON(Lottie) / LOTTIE. سيتم اعتباره متحركًا تلقائيًا إذا كان GIF أو Lottie.</div>
        </div>

        <div class="input">
          <label>متحرّك</label>
          <select name="animated">
            <option value="0"<?= ((int)$row['animated']===0)?' selected':''; ?>>لا</option>
            <option value="1"<?= ((int)$row['animated']===1)?' selected':''; ?>>نعم</option>
          </select>
          <div class="hint">سيتم ضبطها تلقائيًا عند رفع GIF أو Lottie.</div>
        </div>

        <div class="input">
          <label>الترتيب</label>
          <input type="number" name="sort_order" value="<?= (int)$row['sort_order'] ?>">
        </div>
      </div>

      <?php if($row['image_url']): 
        $pathForExt = parse_url((string)$row['image_url'], PHP_URL_PATH) ?: (string)$row['image_url'];
        $extPrev = strtolower(pathinfo($pathForExt, PATHINFO_EXTENSION));
        $isImg = in_array($extPrev, ['png','webp','jpg','jpeg','gif'], true);
        $isLottie = in_array($extPrev, ['json','lottie'], true);
      ?>
        <div style="margin-top:8px;display:flex;align-items:center;gap:10px;">
          <?php if($isImg): ?>
            <img class="thumb" src="<?= e($row['image_url']) ?>" alt="">
            <span class="hint">معاينة الصورة الحالية</span>
          <?php elseif($isLottie): ?>
            <span class="badge">ملف Lottie</span>
            <a href="<?= e($row['image_url']) ?>" target="_blank" class="hint"><?= e($row['image_url']) ?></a>
          <?php else: ?>
            <a href="<?= e($row['image_url']) ?>" target="_blank" class="hint"><?= e($row['image_url']) ?></a>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <div style="display:flex;gap:8px;margin-top:12px;">
        <button class="btn" type="submit"><?= $row['id']?'تحديث':'إضافة' ?></button>
        <a class="btn secondary" href="emojis.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
