<?php
// voicechat/wesaladmin/customer/view.php
declare(strict_types=1);
require_once __DIR__ . '/../../api/config.php';
// include __DIR__.'/../inc/auth.php';

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
if ($id<=0) { http_response_code(400); exit('Bad ticket id'); }

$ticket = $pdo->prepare("SELECT t.*, u.username, u.avatar_url
                         FROM support_tickets t
                         LEFT JOIN users u ON u.id=t.user_id
                         WHERE t.id=? LIMIT 1");
$ticket->execute([$id]);
$T = $ticket->fetch();
if (!$T) { http_response_code(404); exit('Not found'); }

// إرسال رسالة
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['body'])) {
  $body = trim((string)$_POST['body']);
  if ($body !== '') {
    $pdo->prepare("INSERT INTO support_messages
      (ticket_id, sender_user_id, sender_is_agent, body, read_by_user)
      VALUES (?, NULL, 1, ?, 0)")
      ->execute([$id, $body]);
    $pdo->prepare("UPDATE support_tickets SET last_message_at=NOW() WHERE id=?")->execute([$id]);
  }
  header("Location: view.php?id=".$id); exit;
}

// إغلاق التذكرة
if (isset($_GET['close']) && $_GET['close']=='1') {
  $pdo->prepare("UPDATE support_tickets SET status='closed' WHERE id=?")->execute([$id]);
  header("Location: view.php?id=".$id); exit;
}

// الرسائل
$st = $pdo->prepare("SELECT * FROM support_messages WHERE ticket_id=? ORDER BY id ASC");
$st->execute([$id]);
$msgs = $st->fetchAll();

// علّم كمقروء للموظف
$pdo->prepare("UPDATE support_messages SET read_by_agent=1 WHERE ticket_id=?")->execute([$id]);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<meta charset="utf-8">
<title>تذكرة #<?= (int)$T['id'] ?></title>
<body style="font-family:system-ui,-apple-system,Segoe UI,Tahoma; background:#0d1117; color:#e6edf3;">
<div style="max-width:820px;margin:20px auto;">
  <p><a href="index.php" style="color:#58a6ff">← رجوع</a></p>
  <h2>تذكرة #<?= (int)$T['id'] ?> — <?= htmlspecialchars($T['username'] ?? '') ?></h2>
  <p>الحالة: <strong><?= $T['status']==='open'?'مفتوحة':'مغلقة' ?></strong>
    <?php if ($T['status']==='open'): ?>
      <a href="?id=<?= (int)$T['id'] ?>&close=1" style="margin-inline-start:10px;color:#ff9999">[إغلاق]</a>
    <?php endif; ?>
  </p>

  <div style="border:1px solid #30363d;border-radius:10px;padding:12px; background:#0f141c; max-height:60vh; overflow:auto;">
    <?php foreach ($msgs as $m): ?>
      <?php $isAgent = (int)$m['sender_is_agent']===1; ?>
      <div style="margin:8px 0; text-align:<?= $isAgent?'left':'right' ?>;">
        <div style="display:inline-block; padding:10px 12px; border-radius:12px;
                    background:<?= $isAgent?'#1f6feb33':'#23863633' ?>;">
          <div style="opacity:.7;font-size:12px;margin-bottom:4px;">
            <?= $isAgent ? 'الدعم' : ($T['username'] ?? 'مستخدم') ?>
            — <?= htmlspecialchars($m['created_at']) ?>
          </div>
          <div><?= nl2br(htmlspecialchars($m['body'])) ?></div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <?php if ($T['status']==='open'): ?>
  <form method="post" style="margin-top:10px;display:flex;gap:8px;">
    <textarea name="body" rows="3" style="flex:1;border:1px solid #30363d;border-radius:10px;padding:10px;background:#0f141c;color:#e6edf3;"></textarea>
    <button style="padding:10px 14px;border-radius:10px;border:0;background:#238636;color:#fff;cursor:pointer">إرسال</button>
  </form>
  <?php endif; ?>
</div>
</body>
</html>
