<?php
// admin/app_settings.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$msg = null; $err = null;

/* مفاتيح الإعدادات المدعومة — (Android فقط) */
$keys = [
  'android_latest_code',
  'android_latest_name',
  'android_min_code',
  'android_update_url',
  'android_notes_ar',
];

/* تحميل القيم الحالية دفعة واحدة */
function load_settings(PDO $pdo, array $keys): array {
  if (!$keys) return [];
  $in = implode(',', array_fill(0, count($keys), '?'));
  $st = $pdo->prepare("SELECT `key`,`value` FROM app_settings WHERE `key` IN ($in)");
  $st->execute($keys);
  $m = array_fill_keys($keys, '');
  while ($r = $st->fetch(PDO::FETCH_ASSOC)) $m[$r['key']] = (string)$r['value'];
  return $m;
}

/* حفظ القيم (REPLACE) */
function save_settings(PDO $pdo, array $kvs): void {
  $st = $pdo->prepare("REPLACE INTO app_settings (`key`,`value`) VALUES (?,?)");
  foreach ($kvs as $k => $v) $st->execute([$k, (string)$v]);
}

$row = load_settings($pdo, $keys);

/* حفظ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    // قراءة مدخلات Android
    $latest_code = (int)($_POST['android_latest_code'] ?? 1);
    $latest_name = trim((string)($_POST['android_latest_name'] ?? '1.0.0'));
    $min_code    = (int)($_POST['android_min_code'] ?? 1);
    $update_url  = trim((string)($_POST['android_update_url'] ?? ''));
    $notes_ar    = trim((string)($_POST['android_notes_ar'] ?? ''));

    // تحقق أساسي
    if ($latest_code <= 0) { $err = 'latest_code يجب أن يكون رقمًا صحيحًا أكبر من 0.'; goto out; }
    if ($min_code <= 0)    { $err = 'min_code يجب أن يكون رقمًا صحيحًا أكبر من 0.'; goto out; }
    if ($min_code > $latest_code) { $err = 'min_code لا يجوز أن يكون أكبر من latest_code.'; goto out; }
    if ($update_url !== '' && !filter_var($update_url, FILTER_VALIDATE_URL)) {
      $err = 'رابط المتجر غير صالح.'; goto out;
    }

    try {
      save_settings($pdo, [
        'android_latest_code' => $latest_code,
        'android_latest_name' => $latest_name,
        'android_min_code'    => $min_code,
        'android_update_url'  => $update_url,
        'android_notes_ar'    => $notes_ar,
      ]);
      $msg = 'تم الحفظ بنجاح.';
      $row = load_settings($pdo, $keys); // إعادة التحميل
    } catch (Throwable $e) {
      $err = 'تعذّر الحفظ.';
    }
  }
}
out:

$PAGE_TITLE = 'إعدادات التطبيق (Android)';
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
  .settings-page .hint {opacity:.8;font-size:12px}
  .settings-page .mono {font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace}
  .settings-page .grid-2 {display:grid;grid-template-columns:1fr 1fr;gap:12px}
  @media (max-width: 920px){ .settings-page .grid-2 {grid-template-columns:1fr;} }
</style>

<div class="settings-page">
  <div class="card" style="max-width:980px;">
    <h1 style="margin-top:0"><?= e($PAGE_TITLE) ?></h1>
    <?php if($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

      <h3>أكواد الإصدارات</h3>
      <div class="grid-2">
        <div class="input">
          <label>أحدث كود إصدار <span class="mono">(android_latest_code)</span></label>
          <input type="number" name="android_latest_code" value="<?= e($row['android_latest_code']) ?>" min="1" required>
          <div class="hint">آخر <span class="mono">versionCode</span> متاح في المتجر. المستخدمون دونه يُعرض لهم تحديث اختياري.</div>
        </div>

        <div class="input">
          <label>اسم الإصدار <span class="mono">(android_latest_name)</span></label>
          <input name="android_latest_name" value="<?= e($row['android_latest_name']) ?>" placeholder="مثال: 1.0.22" required>
          <div class="hint">يظهر للمستخدم داخل حوار التحديث.</div>
        </div>

        <div class="input">
          <label>أدنى كود مدعوم <span class="mono">(android_min_code)</span></label>
          <input type="number" name="android_min_code" value="<?= e($row['android_min_code']) ?>" min="1" required>
          <div class="hint">إذا كان <span class="mono">buildNumber</span> للمستخدم أقل من هذا الرقم يظهر تحديث <b>إجباري</b>.</div>
        </div>

        <div class="input">
          <label>رابط المتجر <span class="mono">(android_update_url)</span></label>
          <input name="android_update_url" value="<?= e($row['android_update_url']) ?>" placeholder="https://play.google.com/store/apps/details?id=com.package.app">
          <div class="hint">يمكن تركه فارغًا وسيتم استخدام رابط الحزمة تلقائيًا داخل التطبيق.</div>
        </div>
      </div>

      <div class="input" style="margin-top:8px;">
        <label>ملاحظات الإصدار <span class="mono">(android_notes_ar)</span></label>
        <textarea name="android_notes_ar" rows="5" placeholder="ما الجديد في هذا الإصدار؟"><?= e($row['android_notes_ar']) ?></textarea>
        <div class="hint">ستظهر هذه الرسالة في مربع الحوار داخل التطبيق.</div>
      </div>

      <div style="display:flex;gap:8px;margin-top:14px;">
        <button class="btn" type="submit">حفظ الإعدادات</button>
        <a class="btn secondary" href="index.php">رجوع للوحة التحكم</a>
        <a class="btn secondary" href="agent_rate.php">إعداد سعر تحويل الوكلاء</a>
      </div>

      <hr style="margin:18px 0;opacity:.25">

      <details>
        <summary style="cursor:pointer;">معلومة: كيف يعمل التحديث داخل التطبيق؟</summary>
        <div class="hint" style="margin-top:8px;line-height:1.7">
          يتصل التطبيق بواجهة <span class="mono">/voicechat/api/app_update.php</span> ويقرأ القيم أعلاه.
          إذا كان رقم إصدار المستخدم أقل من <span class="mono">android_min_code</span> يظهر له حوار <b>إجباري</b> للتحديث،
          وإذا كان بين <span class="mono">android_min_code</span> و <span class="mono">android_latest_code</span> يظهر حوار <b>اختياري</b>.
        </div>
      </details>
    </form>
  </div>
</div>

<?php require __DIR__ . '/inc/footer.php'; ?>
