<?php
// public_html/voicechat/api/upload.php
// Usage: POST multipart/form-data with field "file" (+ optional "type").
// Requires Bearer token via require_auth() in config.php.
// Returns: { ok: true, url: "https://battle-party.com/voicechat/uploads/room/cover/2025/08/xxx.jpg", type: "room_cover" }

require __DIR__ . '/config.php';
$auth = require_auth();

header('Content-Type: application/json; charset=utf-8');

// للـ CORS البسيط
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  echo json_encode(['ok'=>true]); exit;
}

function fail($msg, $code=400, $extra=[]) {
  http_response_code($code);
  echo json_encode(array_merge(['ok'=>false,'error'=>$msg], $extra), JSON_UNESCAPED_UNICODE);
  exit;
}

// ================== الوجهات ==================
// جذور المسارات
$ROOT_WEB_URL = 'https://battle-party.com/voicechat';
$UPLOADS_DIR  = dirname(__DIR__) . '/uploads';          // /public_html/voicechat/uploads
$UPLOADS_URL  = $ROOT_WEB_URL . '/uploads';

// أنواع الحفظ (يمكنك التوسعة لاحقاً)
$type = $_POST['type'] ?? $_GET['type'] ?? 'room_cover';
$map = [
  'avatar'     => ['dir' => $UPLOADS_DIR . '/avatars',        'url' => $UPLOADS_URL . '/avatars'],
  'room_cover' => ['dir' => $UPLOADS_DIR . '/room/cover',      'url' => $UPLOADS_URL . '/room/cover'],
  'room_bg'    => ['dir' => $UPLOADS_DIR . '/room/background', 'url' => $UPLOADS_URL . '/room/background'],
  'moment'     => ['dir' => $UPLOADS_DIR . '/moment',          'url' => $UPLOADS_URL . '/moment'],
  'banner'     => ['dir' => $UPLOADS_DIR . '/banners',         'url' => $UPLOADS_URL . '/banners'],
];
$bucket = $map[$type] ?? $map['room_cover'];

// تأكد من المجلد الجذري
if (!is_dir($bucket['dir']) && !@mkdir($bucket['dir'], 0775, true)) {
  fail('cannot_create_base_dir', 500);
}

// ================== التحقق من الملف ==================
if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
  fail('no_file', 400);
}

$f = $_FILES['file'];
$maxBytes = 25 * 1024 * 1024; // 25MB
if ($f['size'] > $maxBytes) fail('too_large', 413, ['limit'=>$maxBytes]);

// السماحيات
$mimeAllowed = [
  'image/jpeg' => 'jpg',
  'image/png'  => 'png',
  'image/webp' => 'webp',
  'image/gif'  => 'gif',
  'audio/mpeg' => 'mp3',
  'video/mp4'  => 'mp4',
  'application/pdf' => 'pdf',
  'text/plain' => 'txt',
];
$extAllowed = ['jpg','jpeg','png','webp','gif','mp3','mp4','pdf','txt'];

// حاول كشف الـ MIME ثم امتداد الاسم كاحتياط
$mime = @mime_content_type($f['tmp_name']) ?: '';
$ext  = $mimeAllowed[$mime] ?? null;
if (!$ext) {
  $extName = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
  if (in_array($extName, $extAllowed, true)) {
    $ext = ($extName === 'jpeg') ? 'jpg' : $extName;
  }
}
if (!$ext) fail('type_not_allowed', 415, ['det'=>$mime ?: 'unknown']);

// ================== مسار الحفظ ==================
$y = date('Y'); $m = date('m');
$targetDir = rtrim($bucket['dir'], '/')."/$y/$m";
if (!is_dir($targetDir) && !@mkdir($targetDir, 0775, true)) {
  fail('cannot_create_directory', 500);
}

// اسم ملف عشوائي
$rand = bin2hex(random_bytes(6));
$name = $rand . '.' . $ext;
$dest = $targetDir . '/' . $name;

// انقل الملف
if (!move_uploaded_file($f['tmp_name'], $dest)) {
  fail('move_failed', 500);
}

// اجعل الأذونات مناسبة على الاستضافة المشتركة
@chmod($dest, 0644);

// رابط عمومي
$publicUrl = rtrim($bucket['url'], '/')."/$y/$m/$name";

// الرد
echo json_encode(['ok'=>true, 'url'=>$publicUrl, 'type'=>$type], JSON_UNESCAPED_UNICODE);
