<?php
// voicechat/api/top_gifts.php
// ترتيب "أكثر إرسال/استلام هدايا" مع (اليوم/الأسبوع/الكل)
// يعتمد على جدول: gift_transactions (كما في الصورة)
// الأعمدة المستخدمة: sender_user_id, receiver_user_id, quantity, total_price, room_uid, created_at

require_once __DIR__ . '/config.php';

try {
  // ====== Params ======
  $tab   = strtolower(trim($_GET['tab']   ?? 'senders'));   // senders | receivers
  $range = strtolower(trim($_GET['range'] ?? 'day'));       // day | week | all
  $room  = trim($_GET['room_uid'] ?? '');

  $page  = max(1, (int)($_GET['page']  ?? 1));
  $limit = (int)($_GET['limit'] ?? 50);
  if ($limit < 1)   $limit = 50;
  if ($limit > 200) $limit = 200;
  $offset = ($page - 1) * $limit;

  // تحقق من القيم المسموحة
  $tab = in_array($tab, ['senders','receivers'], true) ? $tab : 'senders';
  $range = in_array($range, ['day','week','all'], true) ? $range : 'day';

  // العمود الذي سنجَمِّع عليه
  $col = ($tab === 'senders') ? 'sender_user_id' : 'receiver_user_id';

  // شروط الوقت
  $where = [];
  $bind  = [];

  if ($range === 'day') {
    $where[] = 'DATE(created_at) = CURDATE()';
  } elseif ($range === 'week') {
    // ISO week (تبدأ الاثنين)
    $where[] = 'YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1)';
  }
  // ترشيح غرفة إن طُلِب
  if ($room !== '') {
    $where[] = 'room_uid = :room_uid';
    $bind[':room_uid'] = $room;
  }

  // تجاهل المستخدم المجهول/الصفر
  $where[] = "$col IS NOT NULL AND $col <> 0";

  $whereSql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

  $pdo = db();

  // إجمالي عدد المستخدمين (لأغراض الترقيم)
  $sqlCount = "SELECT COUNT(DISTINCT $col) AS n
               FROM gift_transactions
               $whereSql";
  $stCount = $pdo->prepare($sqlCount);
  foreach ($bind as $k => $v) $stCount->bindValue($k, $v);
  $stCount->execute();
  $total = (int)($stCount->fetch()['n'] ?? 0);

  // الاستعلام الرئيسي
  // coins = SUM(total_price)  — العدد = SUM(quantity) — عدد العمليات = COUNT(*)
  $sql = "SELECT
            $col AS user_id,
            SUM(total_price) AS coins,
            SUM(quantity)    AS quantity,
            COUNT(*)         AS tx_count,
            MAX(created_at)  AS last_at
          FROM gift_transactions
          $whereSql
          GROUP BY $col
          ORDER BY coins DESC
          LIMIT :limit OFFSET :offset";
  $st = $pdo->prepare($sql);
  foreach ($bind as $k => $v) $st->bindValue($k, $v);
  $st->bindValue(':limit',  $limit,  PDO::PARAM_INT);
  $st->bindValue(':offset', $offset, PDO::PARAM_INT);
  $st->execute();
  $rows = $st->fetchAll();

  // إثراء البيانات بمعلومات المستخدم (الاسم/الأفاتار)
  $items = [];
  foreach ($rows as $r) {
    $uid = (int)$r['user_id'];
    $u = user_summary($uid); // من config.php

    $items[] = [
      'user_id'    => $uid,
       'userid'     => (string)($u['userid'] ?? ''),
      'username'   => (string)($u['username'] ?? 'User#'.$uid),
      'avatar_url' => (string)($u['avatar_url'] ?? ''),
      'coins'      => (int)$r['coins'],
      'quantity'   => (int)$r['quantity'],
      'tx_count'   => (int)$r['tx_count'],
      'last_at'    => (string)$r['last_at'],
    ];
  }

  json_out([
    'ok'    => true,
    'tab'   => $tab,
    'range' => $range,
    'page'  => $page,
    'limit' => $limit,
    'total' => $total,
    'items' => $items,
  ]);

} catch (Throwable $e) {
  // لو كان الجدول غير موجود أو أي خطأ آخر
  json_out([
    'ok' => false,
    'error' => 'server',
    'message' => $e->getMessage(),
  ], 500);
}
