<?php
// voicechat/api/store/items_list.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

/* اتصال قاعدة البيانات */
try { $pdo = db(); }
catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>0,'error'=>'db_connect_failed']); exit;
}

/* المستخدم إن وجد (اختياري) */
$me = null; try { $me = optional_user(); } catch (Throwable $e) {}

/* category المطلوب (slug مثل frame/entry أو حتى رقم category_id) */
$catParam = trim($_GET['category'] ?? $_POST['category'] ?? 'frame');
if ($catParam === '') $catParam = 'frame';

/* جرّب جلب id من جدول store_categories إذا المَعطى slug */
$catSlug = $catParam;
$catId   = 0;
if (ctype_digit($catParam)) {
  $catId = (int)$catParam;     // تم تمرير رقم
  $catSlug = '';               // slug غير معلوم
} else {
  try {
    $st = $pdo->prepare("SELECT id FROM store_categories WHERE slug=? LIMIT 1");
    $st->execute([$catSlug]);
    $catId = (int)($st->fetchColumn() ?: 0);
  } catch (Throwable $e) { /* تجاهل لو الجدول غير موجود */ }
}

/* اجلب العناصر — ندعم المطابقة بالـ slug أو الـ category_id */
$sql = "SELECT id, category, category_id, slug, name, image_url, price, days, rating, is_active, sort_order, meta_json
        FROM store_items
        WHERE is_active=1
          AND (
                category = ?
             OR (? > 0 AND category_id = ?)
          )
        ORDER BY sort_order DESC, id DESC";
$st = $pdo->prepare($sql);
$st->execute([$catSlug, $catId, $catId]);
$items = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* الملكيات (اختياري) */
$owned = [];
if ($me) {
  try {
    $s = $pdo->prepare("SELECT item_id, expires_at FROM user_store_items WHERE user_id=?");
    $s->execute([$me]);
    foreach ($s as $r) $owned[(int)$r['item_id']] = $r['expires_at']; // NULL = دائم
  } catch (Throwable $e) {}
}

$now = time();
$out = [];

foreach ($items as $it) {
  /* ميتا الفيديو/الصورة */
  $meta = [];
  if (!empty($it['meta_json'])) {
    $tmp = json_decode($it['meta_json'], true);
    if (is_array($tmp)) $meta = $tmp;
  }

  $mediaType = (string)($meta['type'] ?? $meta['media_type']
                 ?? ((isset($meta['video']) || isset($meta['video_url'])) ? 'video' : 'image'));
  $videoUrl  = (string)($meta['video'] ?? $meta['video_url'] ?? '');
  $thumbUrl  = (string)($meta['thumb'] ?? $meta['thumb_url'] ?? '');
  $duration  = isset($meta['duration']) ? (int)$meta['duration']
             : (isset($meta['duration_seconds']) ? (int)$meta['duration_seconds'] : null);

  /* صورة العرض: نفضّل المصغّرة ثم image_url */
  $imageUrl = $thumbUrl !== '' ? $thumbUrl : (string)($it['image_url'] ?? '');

  /* حساب الملكية */
  $id   = (int)$it['id'];
  $exp  = $owned[$id] ?? null;
  $ownedNow = false; $remain = null;
  if (array_key_exists($id, $owned)) {
    if ($exp === null) { $ownedNow = true; }
    else {
      $t = strtotime($exp);
      if ($t > $now) { $ownedNow = true; $remain = ceil(($t-$now)/86400); }
    }
  }

  $out[] = [
    'id'          => $id,
    'category'    => $it['category'],
    'slug'        => $it['slug'],
    'name'        => $it['name'],
    'image_url'   => $imageUrl,              // قد تكون فارغة لو ما في صورة
    'price'       => (int)$it['price'],
    'days'        => $it['days']   !== null ? (int)$it['days']   : null,
    'rating'      => $it['rating'] !== null ? (int)$it['rating'] : null,

    // وسائط اختيارية (للدخوليات)
    'media_type'  => $mediaType,             // 'video' | 'image'
    'video_url'   => $videoUrl !== '' ? $videoUrl : null,
    'thumb_url'   => $thumbUrl !== '' ? $thumbUrl : null,
    'duration'    => $duration,

    // ملكية (اختياري)
    'owned'          => $ownedNow,
    'remaining_days' => $remain,
  ];
}

echo json_encode(['ok'=>1, 'items'=>$out], JSON_UNESCAPED_UNICODE);
