<?php
// room_frame_state.php
declare(strict_types=1);

require __DIR__ . '/config.php';

function ok($data, int $code = 200) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}
function bad(string $msg, int $code = 400) { ok(['ok' => false, 'error' => $msg], $code); }

/** مصادقة اختيارية (للقراءة لا نشترطها) */
$auth = function_exists('require_auth') ? require_auth() : ['uid' => 'guest'];
$user_uid = (string)($auth['uid'] ?? 'guest');

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$pdo = db();

if ($method === 'GET') {
  $room_uid = trim((string)($_GET['room_uid'] ?? ''));
  if ($room_uid === '') bad('missing_room_uid', 422);

  // نقرأ فقط seat_index, user_uid, frame_pag_url من users
  $sql = "
    SELECT
      m.seat_index,
      m.user_uid,
      COALESCE(u.frame_pag_url, '') AS frame_pag_url
    FROM room_mics m
    LEFT JOIN users u ON u.uid = m.user_uid
    WHERE m.room_uid = ?
    ORDER BY m.seat_index ASC
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$room_uid]);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  $frames = [];
  foreach ($rows as $r) {
    $uid   = (string)($r['user_uid'] ?? '');
    $frame = (string)($r['frame_pag_url'] ?? '');
    $frames[] = [
      'seat_index'    => (int)$r['seat_index'],
      'user_uid'      => $uid,
      'frame_url'     => $frame, // للتوافق مع الواجهة التي تبحث عن frame_url
      'frame_pag_url' => $frame, // الاسم الأصلي في القاعدة
      'is_me'         => ($uid !== '' && $uid === $user_uid),
    ];
  }

  ok(['ok' => true, 'room_uid' => $room_uid, 'frames' => $frames]);
}

/* (اختياري) تحديث إطار المستخدم نفسه */
if ($method === 'POST') {
  if ($user_uid === 'guest') bad('unauthorized', 401);

  $raw  = file_get_contents('php://input');
  $body = json_decode($raw, true);
  if (!is_array($body)) $body = $_POST ?? [];

  $action = strtolower(trim((string)($body['action'] ?? '')));
  if ($action !== 'set') bad('unknown_action', 422);

  $frame = trim((string)($body['frame_url'] ?? $body['frame_pag_url'] ?? ''));
  // سماح بس بفارغ لإزالة أو https/http(s) كامل:
  if ($frame !== '' && !preg_match('~^https?://~i', $frame)) {
    bad('invalid_frame_url', 422);
  }

  try {
    $st = $pdo->prepare("UPDATE users SET frame_pag_url = ? WHERE uid = ?");
    $st->execute([$frame !== '' ? $frame : null, $user_uid]);
    ok(['ok' => true]);
  } catch (Throwable $e) {
    bad('db_error', 500);
  }
}

bad('method_not_allowed', 405);
