<?php
// voicechat/api/room_admins_list.php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'GET') {
  json_out(['ok'=>false,'error'=>'method_not_allowed'], 405);
}

$pdo = db();
$me  = require_user(); // uid الحالي من الـ Bearer

$roomUid = trim((string)($_GET['room_uid'] ?? ''));
if ($roomUid === '') json_out(['ok'=>false,'error'=>'missing_room_uid'], 400);

/* اختياري: السماح فقط لمالك الغرفة أو الأدمن برؤية القائمة */
$isOwner = false;
$st = $pdo->prepare("SELECT owner_uid FROM rooms WHERE uid=? LIMIT 1");
$st->execute([$roomUid]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if ($row) $isOwner = ($row['owner_uid'] === $me);

$st = $pdo->prepare("SELECT 1 FROM room_admins WHERE room_uid=? AND admin_uid=? LIMIT 1");
$st->execute([$roomUid, $me]);
$isAdmin = (bool)$st->fetchColumn();

if (!$isOwner && !$isAdmin) {
  json_out(['ok'=>false,'error'=>'forbidden'], 403);
}

$sql = "SELECT ra.admin_uid AS uid, u.username, u.avatar_url, ra.created_at
        FROM room_admins ra
        LEFT JOIN users u ON u.uid = ra.admin_uid
        WHERE ra.room_uid=?
        ORDER BY ra.created_at ASC";
$st = $pdo->prepare($sql);
$st->execute([$roomUid]);
$admins = $st->fetchAll(PDO::FETCH_ASSOC);

json_out(['ok'=>true, 'admins'=>$admins]);
