<?php
require_once __DIR__ . '/../config.php';

try {
  $pdo = db();

  $post_id = (int)($_GET['post_id'] ?? 0);
  if ($post_id <= 0) {
    respond(['ok' => 0, 'error' => 'post_required'], 422);
  }

  // تأكد أن المنشور موجود
  $chk = $pdo->prepare('SELECT 1 FROM moment_posts WHERE id = ?');
  $chk->execute([$post_id]);
  if (!$chk->fetchColumn()) {
    respond(['ok' => 0, 'error' => 'post_not_found'], 404);
  }

  // التصفح
  $page    = max(1, (int)($_GET['page'] ?? 1));
  $perPage = max(1, min(100, (int)($_GET['per_page'] ?? 50)));
  $offset  = ($page - 1) * $perPage;

  // إجمالي التعليقات (اختياري لكنه مفيد لـ has_more)
  $tc = $pdo->prepare('SELECT COUNT(*) FROM moment_comments WHERE post_id = ?');
  $tc->execute([$post_id]);
  $total = (int)$tc->fetchColumn();

  // جلب التعليقات
  $sql = "
    SELECT
      c.id,
      c.post_id,
      c.user_id,
      c.text,
      c.created_at,
      u.username,
      COALESCE(u.avatar_url, '') AS avatar_url
    FROM moment_comments c
    JOIN users u ON u.id = c.user_id
    WHERE c.post_id = ?
    ORDER BY c.id ASC
    LIMIT $perPage OFFSET $offset
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$post_id]);
  $rows = $st->fetchAll();

  $hasMore = ($offset + count($rows) < $total);

  respond([
    'ok'        => 1,
    'comments'  => $rows,
    'page'      => $page,
    'per_page'  => $perPage,
    'total'     => $total,
    'has_more'  => $hasMore ? 1 : 0,
  ], 200);

} catch (Throwable $e) {
  respond(['ok' => 0, 'error' => $e->getMessage()], 500);
}
