<?php
// voicechat/api/family/rank.php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';

$pdo = db();

// period = daily | weekly | all
$period = strtolower(trim($_GET['period'] ?? 'daily'));
if (!in_array($period, ['daily','weekly','all'], true)) {
  $period = 'daily';
}

// نافذة الزمن
$sinceExpr = '';
if ($period === 'daily') {
  $sinceExpr = 'CURDATE()';
} elseif ($period === 'weekly') {
  $sinceExpr = '(CURRENT_DATE - INTERVAL 7 DAY)';
}

// نقرأ أعمدة جدول families الموجودة فعليًا
$cols = $pdo->query("
  SELECT COLUMN_NAME
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'families'
")->fetchAll(PDO::FETCH_COLUMN);
$has = fn(string $c) => in_array($c, $cols, true);

// نبني تعبير الاسم والصورة حسب الأعمدة المتاحة
// الاسم
if ($has('title')) {
  $nameExpr = "COALESCE(NULLIF(fam.name,''), NULLIF(fam.title,''), '—')";
} else {
  $nameExpr = "COALESCE(NULLIF(fam.name,''), '—')";
}
// الصورة (أول عمود متاح من المجموعة التالية)
if     ($has('badge_url')) $badgeExpr = 'fam.badge_url';
elseif ($has('image_url')) $badgeExpr = 'fam.image_url';
elseif ($has('logo_url'))  $badgeExpr = 'fam.logo_url';
elseif ($has('logo'))      $badgeExpr = 'fam.logo';
else                       $badgeExpr = 'NULL';

$sql = "
WITH base AS (
  SELECT sender_user_id   AS uid, total_price AS points, created_at
  FROM gift_transactions
  UNION ALL
  SELECT receiver_user_id AS uid, total_price AS points, created_at
  FROM gift_transactions
  WHERE receiver_user_id IS NOT NULL
),
filtered AS (
  SELECT * FROM base " . ($sinceExpr ? "WHERE created_at >= $sinceExpr" : "") . "
),
family_scores AS (
  SELECT fm.family_id, SUM(f.points) AS score
  FROM filtered f
  JOIN family_members fm ON fm.user_uid = f.uid
  GROUP BY fm.family_id
),
family_members_count AS (
  SELECT family_id, COUNT(*) AS members FROM family_members GROUP BY family_id
)
SELECT
  ROW_NUMBER() OVER (ORDER BY fs.score DESC) AS `rank`,
  fam.id AS family_id,
  $nameExpr  AS name,
  $badgeExpr AS badge_url,
  COALESCE(mc.members, 0) AS members,
  fs.score
FROM family_scores fs
JOIN families fam ON fam.id = fs.family_id
LEFT JOIN family_members_count mc ON mc.family_id = fam.id
ORDER BY `rank`
LIMIT 100
";

try {
  $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
  json_out(['ok' => true, 'data' => $rows]);
} catch (Throwable $e) {
  // لو حصل خطأ نرجع رسالة واضحة بدل HTTP 500 مبهمة
  json_out(['ok' => false, 'error' => $e->getMessage()], 500);
}
