<?php
// voicechat/api/family/join.php
require_once __DIR__ . '/../config.php'; // يوفر db(), json_out(), json_in(), bearer_user_id(), CORS...

$DEBUG = isset($_GET['debug']) || isset($_POST['debug']);
if ($DEBUG) { error_reporting(E_ALL); ini_set('display_errors','1'); }

// مساعد لقراءة بارامترات POST/GET/JSON
function in_param(string $k, array $J) {
  if (isset($_POST[$k])) return $_POST[$k];
  if (isset($_GET[$k]))  return $_GET[$k];
  if (isset($J[$k]))     return $J[$k];
  return null;
}

try {
  $pdo = db();

  // نقرأ JSON إن وُجد
  $J = json_in(); // معرّفة في config.php، ترجع [] لو ما في JSON

  // 1) family_id
  $family_id = in_param('family_id', $J);
  if ($family_id === null || !ctype_digit((string)$family_id)) {
    json_out(['ok'=>false,'joined'=>false,'error'=>'missing_family_id','hint'=>'send family_id in JSON/POST/GET']);
  }
  $family_id = (int)$family_id;

  // 2) user_uid (إن لم يصل نأخذه من Bearer JWT)
  $user_uid = in_param('user_uid', $J);
  if ($user_uid === null || $user_uid === '') {
    $uidFromToken = bearer_user_id(); // يرجّع users.id (int) من الـ JWT أو 0
    if ($uidFromToken > 0) $user_uid = $uidFromToken;
  }
  if ($user_uid === null || !ctype_digit((string)$user_uid)) {
    json_out(['ok'=>false,'joined'=>false,'error'=>'missing_user_uid','hint'=>'send user_uid or Authorization: Bearer <JWT>']);
  }
  $user_uid = (int)$user_uid;

  // 3) معلومات العائلة (اختياريًا: allow_join/capacity)
  $capacity = 2000;
  $allow_join = 1; // نفترض مسموح إذا لم يوجد عمود
  $famFound = false;

  foreach (['families','family'] as $tbl) {
    try {
      $sql = "SELECT id,
                 COALESCE(capacity, COALESCE(max_members, 2000)) AS capacity,
                 COALESCE(allow_join, 1) AS allow_join
              FROM {$tbl} WHERE id=? LIMIT 1";
      $st = $pdo->prepare($sql);
      $st->execute([$family_id]);
      if ($row = $st->fetch(PDO::FETCH_ASSOC)) {
        $famFound = true;
        $capacity   = (int)$row['capacity'];
        $allow_join = (int)$row['allow_join'];
        break;
      }
    } catch (Throwable $e) {
      // تجاهل لو الجدول غير موجود بهذا الاسم
    }
  }
  if (!$famFound) {
    // لو ما عندك جدول للعوائل، لا نمنع — اعتبرها موجودة
    $capacity = max(1, (int)$capacity);
  } else {
    if ($capacity <= 0) $capacity = 2000;
    if ($allow_join === 0) {
      json_out(['ok'=>false,'joined'=>false,'error'=>'join_disabled']);
    }
  }

  // 4) هل المستخدم في عائلة أخرى؟
  $st = $pdo->prepare('SELECT family_id FROM family_members WHERE user_uid=? LIMIT 1');
  $st->execute([$user_uid]);
  if ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    $curr = (int)$row['family_id'];
    if ($curr !== $family_id) {
      json_out([
        'ok'=>false,
        'joined'=>false,
        'error'=>'already_in_other_family',
        'current_family_id'=>$curr
      ]);
    }
  }

  // 5) هل هو عضو مسبقًا في نفس العائلة؟
  $st = $pdo->prepare('SELECT 1 FROM family_members WHERE family_id=? AND user_uid=? LIMIT 1');
  $st->execute([$family_id, $user_uid]);
  if ($st->fetchColumn()) {
    json_out(['ok'=>true,'joined'=>true,'already_member'=>true]);
  }

  // 6) تحقق من السعة
  $st = $pdo->prepare('SELECT COUNT(*) FROM family_members WHERE family_id=?');
  $st->execute([$family_id]);
  $cnt = (int)$st->fetchColumn();
  if ($cnt >= $capacity) {
    json_out([
      'ok'=>false,
      'joined'=>false,
      'error'=>'family_full',
      'capacity'=>$capacity,
      'members'=>$cnt
    ]);
  }

  // 7) الانضمام
  // تأكد من وجود فهرس/قيْد يمنع التكرار (اختياري في قاعدة البيانات):
  // UNIQUE KEY uniq_family_member (family_id, user_uid)
  $st = $pdo->prepare('INSERT INTO family_members (family_id, user_uid, role, joined_at)
                       VALUES (?, ?, "member", NOW())');
  $st->execute([$family_id, $user_uid]);

  json_out(['ok'=>true,'joined'=>true]);

} catch (Throwable $e) {
  $resp = ['ok'=>false,'joined'=>false,'error'=>'server_error'];
  if ($DEBUG) $resp['msg'] = $e->getMessage();
  json_out($resp, 500);
}
