<?php
// voicechat/api/family/create.php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';

$uid = require_user(); // يتحقق من JWT ويعيد users.id

$pdo = db();
$pdo->beginTransaction();

try {
  // لا تملك عائلة مسبقًا؟
  $st = $pdo->prepare("SELECT 1 FROM families WHERE owner_uid=? LIMIT 1");
  $st->execute([$uid]);
  if ($st->fetch()) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'already_has_family'], 400);
  }

  // لست عضوًا في أي عائلة؟
  $st = $pdo->prepare("SELECT 1 FROM family_members WHERE user_uid=? LIMIT 1");
  $st->execute([$uid]);
  if ($st->fetch()) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'already_in_family'], 400);
  }

  $name  = trim($_POST['name'] ?? '');
  $ann   = trim($_POST['announcement'] ?? '');
  $allow = (int)(($_POST['allow_join'] ?? '1') === '1' ? 1 : 0);

  if ($name === '' || mb_strlen($name) > 32) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'bad_name'], 400);
  }

  // شعار (اختياري)
  $badgeUrl = null;
  $FILES_FAMILY_BASE_DIR = dirname(__DIR__) . '/files/family';
  $FILES_FAMILY_BASE_URL = 'https://battle-party.com/voicechat/api/files/family';
  if (!is_dir($FILES_FAMILY_BASE_DIR)) @mkdir($FILES_FAMILY_BASE_DIR, 0775, true);

  if (!empty($_FILES['logo']) && is_uploaded_file($_FILES['logo']['tmp_name'])) {
    $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png','webp'], true)) $ext = 'jpg';
    $fname = 'logo_' . $uid . '_' . time() . '.' . $ext;
    $dest  = $FILES_FAMILY_BASE_DIR . '/' . $fname;
    if (!move_uploaded_file($_FILES['logo']['tmp_name'], $dest)) {
      $pdo->rollBack();
      json_out(['ok'=>false,'error'=>'upload_failed'], 500);
    }
    $badgeUrl = $FILES_FAMILY_BASE_URL . '/' . $fname;
  }

  // إنشاء العائلة
  $st = $pdo->prepare("INSERT INTO families (owner_uid, name, badge_url, announcement, allow_join)
                       VALUES (?,?,?,?,?)");
  $st->execute([$uid, $name, $badgeUrl, $ann ?: null, $allow]);

  $familyId = (int)$pdo->lastInsertId();

  // Trigger سيُضيف المالك كـ owner في family_members تلقائيًا.
  $pdo->commit();
  json_out(['ok'=>true,'family_id'=>$familyId]);

} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  if (str_contains($e->getMessage(), 'uniq_family_name')) {
    json_out(['ok'=>false,'error'=>'name_taken'], 400);
  }
  json_out(['ok'=>false,'error'=>'server_error','details'=>$e->getMessage()], 500);
}
