<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

// مصادقة بنفس أسلوب باقي السكربتات (اختياري لو حاب تحميه)
$payload = require_auth();

// إدخال مرن: GET/POST/JSON
$in = $_POST; if (empty($in)) $in = $_GET; if (empty($in)) $in = json_in();
$roomUid = trim((string)($in['room_uid'] ?? ''));
$sinceId = (int)($in['since_id'] ?? 0);
if ($roomUid === '') {
  json_out(['ok'=>false, 'error'=>'missing_params'], 400);
}

$pdo = db();
$sql = "
  SELECT e.id, e.user_uid, e.emoji_id, e.created_at,
         em.image_url
  FROM room_emoji_events e
  JOIN emojis em ON em.id = e.emoji_id
  WHERE e.room_uid = ?
    AND e.id > ?
  ORDER BY e.id ASC
  LIMIT 100
";
$st = $pdo->prepare($sql);
$st->execute([$roomUid, $sinceId]);

$events = [];
while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
  $events[] = [
    'id'        => (int)$r['id'],
    'user_uid'  => (string)$r['user_uid'],
    'emoji_id'  => (int)$r['emoji_id'],
    'image_url' => (function($p){
      if (!$p) return null;
      if (preg_match('~^https?://~i',$p)) return $p;
      $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
      $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
      return $scheme.'://'.$host.(str_starts_with($p,'/') ? $p : '/'.$p);
    })($r['image_url']),
    'ts'        => $r['created_at'],
  ];
}

json_out(['ok'=>true, 'events'=>$events]);
